/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.network.model;

import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v141.network.model.DirectSocketDnsQueryType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPSocketOptions {
    private final Optional<String> remoteAddr;
    private final Optional<Integer> remotePort;
    private final Optional<String> localAddr;
    private final Optional<Integer> localPort;
    private final Optional<DirectSocketDnsQueryType> dnsQueryType;
    private final Optional<Number> sendBufferSize;
    private final Optional<Number> receiveBufferSize;

    public DirectUDPSocketOptions(Optional<String> remoteAddr, Optional<Integer> remotePort, Optional<String> localAddr, Optional<Integer> localPort, Optional<DirectSocketDnsQueryType> dnsQueryType, Optional<Number> sendBufferSize, Optional<Number> receiveBufferSize) {
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.dnsQueryType = dnsQueryType;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
    }

    public Optional<String> getRemoteAddr() {
        return this.remoteAddr;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    public Optional<String> getLocalAddr() {
        return this.localAddr;
    }

    public Optional<Integer> getLocalPort() {
        return this.localPort;
    }

    public Optional<DirectSocketDnsQueryType> getDnsQueryType() {
        return this.dnsQueryType;
    }

    public Optional<Number> getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Optional<Number> getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    private static DirectUDPSocketOptions fromJson(JsonInput input) {
        Optional<String> remoteAddr = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        Optional<String> localAddr = Optional.empty();
        Optional<Integer> localPort = Optional.empty();
        Optional<DirectSocketDnsQueryType> dnsQueryType = Optional.empty();
        Optional<Number> sendBufferSize = Optional.empty();
        Optional<Number> receiveBufferSize = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "remoteAddr": {
                    remoteAddr = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block18;
                }
                case "localAddr": {
                    localAddr = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "localPort": {
                    localPort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block18;
                }
                case "dnsQueryType": {
                    dnsQueryType = Optional.ofNullable((DirectSocketDnsQueryType)((Object)input.read(DirectSocketDnsQueryType.class)));
                    continue block18;
                }
                case "sendBufferSize": {
                    sendBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
                case "receiveBufferSize": {
                    receiveBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPSocketOptions(remoteAddr, remotePort, localAddr, localPort, dnsQueryType, sendBufferSize, receiveBufferSize);
    }
}

