/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.behavior;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.richfaces.javascript.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUpdateScript
extends ScriptStringBase
implements ScriptString {
    private static final Function<? super FacesMessage, Message> MESSAGES_TRANSFORMER = new Function<FacesMessage, Message>(){

        public Message apply(FacesMessage msg) {
            return new Message(msg);
        }
    };
    private final ImmutableList<Message> messages;
    private final String clientId;

    public MessageUpdateScript(String clientId, Iterator<FacesMessage> messages) {
        this.clientId = clientId;
        this.messages = ImmutableList.copyOf((Iterator)Iterators.transform(messages, MESSAGES_TRANSFORMER));
    }

    public void appendScript(Appendable target) throws IOException {
        JSFunction resetMessages = new JSFunction("RichFaces.csv.clearMessage", new Object[]{this.clientId});
        resetMessages.appendScript(target);
        target.append(';');
        for (Message message : this.messages) {
            JSFunction sendMessage = new JSFunction("RichFaces.csv.sendMessage", new Object[]{this.clientId, message});
            sendMessage.appendScript(target);
            target.append(';');
        }
    }
}

