/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.component.UIDataTable;
import org.richfaces.event.FilteringEvent;
import org.richfaces.event.SortingEvent;
import org.richfaces.taglib.MethodExpressionFilteringListener;
import org.richfaces.taglib.MethodExpressionSortingListener;

public class DataTableHandler
extends ComponentHandler {
    private static final SortingFilteringRule METARULE = new SortingFilteringRule();

    public DataTableHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.addRule((MetaRule)METARULE);
        return m;
    }

    static final class FilteringListenerMapper
    extends Metadata {
        private static final Class[] SIGNATURE = new Class[]{FilteringEvent.class};
        private final TagAttribute attribute;

        public FilteringListenerMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIDataTable)((Object)instance)).addFilteringListener(new MethodExpressionFilteringListener(this.attribute.getMethodExpression(ctx, null, SIGNATURE)));
        }
    }

    static final class SortingListenerMapper
    extends Metadata {
        private static final Class[] SIGNATURE = new Class[]{SortingEvent.class};
        private final TagAttribute attribute;

        public SortingListenerMapper(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIDataTable)((Object)instance)).addSortingListener(new MethodExpressionSortingListener(this.attribute.getMethodExpression(ctx, null, SIGNATURE)));
        }
    }

    static class SortingFilteringRule
    extends MetaRule {
        SortingFilteringRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(UIDataTable.class)) {
                if ("sortingListener".equals(name)) {
                    return new SortingListenerMapper(attribute);
                }
                if ("filteringListener".equals(name)) {
                    return new FilteringListenerMapper(attribute);
                }
            }
            return null;
        }
    }
}

