/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.AbstractMediaOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaOutputRenderer
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.MediaOutputRenderer";
    private static final Map<String, String> URI_ATTRIBUTES = new HashMap<String, String>();

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractMediaOutput mmedia = (AbstractMediaOutput)component;
        String element = mmedia.getElement();
        if (null == element) {
            throw new FacesException(Messages.getMessage((String)"NULL_ATTRIBUTE_ERROR", (Object)"element", (Object)component.getClientId(context)));
        }
        writer.endElement(element);
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractMediaOutput.class;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractMediaOutput mmedia = (AbstractMediaOutput)component;
        String element = mmedia.getElement();
        if (null == element) {
            throw new FacesException(Messages.getMessage((String)"NULL_ATTRIBUTE_ERROR", (Object)"element", (Object)component.getClientId(context)));
        }
        String uriAttribute = mmedia.getUriAttribute();
        if (null == uriAttribute && null == (uriAttribute = URI_ATTRIBUTES.get(element))) {
            throw new FacesException(Messages.getMessage((String)"NULL_ATTRIBUTE_ERROR", (Object)"uriAttribute", (Object)component.getClientId(context)));
        }
        writer.startElement(element, (UIComponent)mmedia);
        this.getUtils().encodeId(context, component);
        StringBuilder uri = new StringBuilder(mmedia.getResource().getRequestPath());
        boolean haveQestion = uri.indexOf("?") >= 0;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)child;
            String name = uiParam.getName();
            Object value = uiParam.getValue();
            if (null == value) continue;
            if (haveQestion) {
                uri.append('&');
            } else {
                uri.append('?');
                haveQestion = true;
            }
            uri.append(name).append('=').append(value.toString());
        }
        writer.writeURIAttribute(uriAttribute, (Object)uri, "uri");
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodePassThru(context, (UIComponent)mmedia, null);
    }

    static {
        URI_ATTRIBUTES.put("a", "href");
        URI_ATTRIBUTES.put("img", "src");
        URI_ATTRIBUTES.put("object", "data");
        URI_ATTRIBUTES.put("link", "href");
    }
}

