/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.IterationStateHolder;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.DataScrollerUtils;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public class UIDataScroller
extends UIComponentBase
implements DataScrollerSource,
IterationStateHolder {
    public static final String COMPONENT_TYPE = "org.richfaces.DataScroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataScroller";
    public static final String SCROLLER_STATE_ATTRIBUTE = "org.richfaces.DataScroller:page";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";
    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";
    public static final String PAGEMODE_FULL = "full";
    public static final String PAGEMODE_SHORT = "short";
    private static final int MAX_PAGES_DEFAULT = 10;
    private Integer page;

    public String getLastPageMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lastPageMode));
    }

    public void setLastPageMode(String lastPageMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastPageMode), (Object)lastPageMode);
    }

    public int getFastStep() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fastStep), (Object)0);
    }

    public void setFastStep(int fastStep) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fastStep), (Object)fastStep);
    }

    public String getForComponent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.forComponent));
    }

    public void setForComponent(String forComponent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forComponent), (Object)forComponent);
    }

    public int getMaxPages() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxPages), (Object)10);
    }

    public void setMaxPages(int maxPages) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxPages), (Object)maxPages);
    }

    public String getBoundaryControls() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.boundaryControls), (Object)"show");
    }

    public void setBoundaryControls(String boundaryControls) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.boundaryControls), (Object)boundaryControls);
    }

    public String getFastControls() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fastControls), (Object)"show");
    }

    public void setFastControls(String fastControls) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fastControls), (Object)fastControls);
    }

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent)event;
            this.updateModel(dataScrollerEvent.getPage());
            FacesContext facesContext = this.getFacesContext();
            UIComponent dataTable = this.getDataTable();
            List<UIDataScroller> dataScrollers = DataScrollerUtils.findDataScrollers(dataTable);
            for (UIDataScroller dataScroller : dataScrollers) {
                facesContext.getPartialViewContext().getRenderIds().add(dataScroller.getClientId(facesContext));
            }
            String dataTableId = null;
            if (dataTable instanceof MetaComponentResolver) {
                dataTableId = ((MetaComponentResolver)dataTable).resolveClientId(facesContext, dataTable, "body");
            }
            if (dataTableId == null) {
                dataTableId = dataTable.getClientId(facesContext);
            }
            facesContext.getPartialViewContext().getRenderIds().add(dataTableId);
            String dataScrollerId = this.getClientId(facesContext);
            if (!facesContext.getPartialViewContext().getRenderIds().contains(dataScrollerId)) {
                facesContext.getPartialViewContext().getRenderIds().add(dataScrollerId);
            }
        }
        super.broadcast(event);
    }

    public UIComponent getDataTable() {
        String forAttribute = (String)this.getAttributes().get(PropertyKeys.forComponent.toString());
        if (forAttribute == null) {
            UIDataScroller forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData) && !(forComp instanceof UIDataAdaptor)) continue;
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.forComponent), (Object)forComp.getId());
                return forComp;
            }
            throw new FacesException("could not find dataTable for  datascroller " + this.getId());
        }
        UIComponent forComp = RendererUtils.getInstance().findComponentFor((UIComponent)this, forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData) && !(forComp instanceof UIDataAdaptor)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + UIData.class.getName() + " or " + UIDataAdaptor.class + ", not type " + forComp.getClass().getName());
        }
        return forComp;
    }

    private int getFastStepOrDefault() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fastStep), (Object)1);
    }

    public int getPageForFacet(String facetName) {
        if (facetName == null) {
            throw new NullPointerException();
        }
        int newPage = 1;
        int pageCount = this.getPageCount();
        if (FIRST_FACET_NAME.equals(facetName)) {
            newPage = 1;
        } else if (LAST_FACET_NAME.equals(facetName)) {
            newPage = pageCount > 0 ? pageCount : 1;
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() + this.getFastStepOrDefault();
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() - this.getFastStepOrDefault();
        } else {
            try {
                newPage = Integer.parseInt(facetName.toString());
            }
            catch (NumberFormatException e) {
                throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (newPage >= 1 && newPage <= pageCount) {
            return newPage;
        }
        return 0;
    }

    public int getPageCount(UIComponent data) {
        int rowCount = this.getRowCount(data);
        int rows = this.getRows(data);
        return this.getPageCount(data, rowCount, rows);
    }

    public int getPageCount(UIComponent data, int rowCount, int rows) {
        return DataScrollerUtils.getPageCount(data, rowCount, rows);
    }

    public int getPageCount() {
        return this.getPageCount(this.getDataTable());
    }

    public int getRowCount(UIComponent data) {
        return (Integer)data.getAttributes().get("rowCount");
    }

    public int getRowCount() {
        return this.getRowCount(this.getDataTable());
    }

    public int getRows(UIComponent data) {
        return DataScrollerUtils.getRows(data);
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacetByKey(LAST_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacetByKey(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacetByKey(FAST_REWIND_FACET_NAME);
    }

    private UIComponent getFacetByKey(String key) {
        return this.getFacet(key.toString());
    }

    private static boolean isRendered(UIComponent component) {
        for (UIComponent c = component; c != null; c = c.getParent()) {
            if (c.isRendered()) continue;
            return false;
        }
        return true;
    }

    public void setPage(int newPage) {
        this.page = newPage;
    }

    public int getPage() {
        FacesContext facesContext;
        UIComponent dataTable = this.getDataTable();
        Map attributes = dataTable.getAttributes();
        Integer state = (Integer)attributes.get(dataTable.getClientId(facesContext = this.getFacesContext()) + SCROLLER_STATE_ATTRIBUTE);
        if (state != null) {
            return state;
        }
        if (this.page != null) {
            return this.page;
        }
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                Integer pageObject = (Integer)ve.getValue(this.getFacesContext().getELContext());
                if (pageObject != null) {
                    return pageObject;
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return 1;
    }

    private void updateModel(int newPage) {
        FacesContext facesContext = this.getFacesContext();
        UIComponent dataTable = this.getDataTable();
        if (UIDataScroller.isRendered(dataTable)) {
            dataTable.getAttributes().put(FIRST_FACET_NAME, (newPage - 1) * this.getRows(dataTable));
        }
        Map attributes = dataTable.getAttributes();
        attributes.put(dataTable.getClientId(facesContext) + SCROLLER_STATE_ATTRIBUTE, newPage);
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                ve.setValue(facesContext.getELContext(), (Object)newPage);
                attributes.remove(dataTable.getClientId(facesContext) + SCROLLER_STATE_ATTRIBUTE);
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageUtil.getMessage((FacesContext)facesContext, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                facesContext.getExternalContext().log(message.getSummary(), result);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)facesContext, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)this)});
                facesContext.getExternalContext().log(message.getSummary(), (Throwable)e);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
            catch (Exception e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)facesContext, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)this)});
                facesContext.getExternalContext().log(message.getSummary(), (Throwable)e);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
        }
    }

    public boolean isLocalPageSet() {
        return this.page != null;
    }

    public void resetLocalPage() {
        this.page = null;
    }

    public String getFamily() {
        return "org.richfaces.DataScroller";
    }

    public Object getIterationState() {
        return this.page;
    }

    public void setIterationState(Object state) {
        this.page = (Integer)state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        boundaryControls,
        fastControls,
        fastStep,
        forComponent,
        inactiveStyle,
        selectStyle,
        inactiveStyleClass,
        selectStyleClass,
        scrollerListener,
        lastPageMode,
        maxPages,
        pageIndexVar,
        pagesVar,
        renderIfSinglePage,
        style,
        styleClass,
        stepControls;

    }
}

