/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.h3xstream.retirejs.repo.JsLibrary;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.JsVulnerability;
import com.h3xstream.retirejs.repo.ScannerFacade;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepositoryLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.search.FileContentSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class RetireJsAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetireJsAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "js";
    private static final String ANALYZER_NAME = "RetireJS Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.FINDING_ANALYSIS;
    private static final String[] EXTENSIONS = new String[]{"js"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(EXTENSIONS).build();
    private VulnerabilitiesRepository jsRepository;
    private String[] filters = null;
    private boolean skipNonVulnerableInJAR = true;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public boolean accept(File pathname) {
        try {
            boolean filesMatched = super.getFilesMatched();
            boolean accepted = super.accept(pathname);
            if (accepted && this.filters != null && FileContentSearch.contains((File)pathname, (String[])this.filters)) {
                if (!filesMatched) {
                    super.setFilesMatched(filesMatched);
                }
                return false;
            }
            return accepted;
        }
        catch (IOException ex) {
            LOGGER.warn(String.format("Error testing file %s", pathname), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void initialize(Settings settings) {
        super.initialize(settings);
        if (this.isEnabled()) {
            this.filters = settings.getArray("analyzer.retirejs.filters");
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        File repoFile = null;
        try {
            repoFile = new File(this.getSettings().getDataDirectory(), "jsrepository.json");
        }
        catch (FileNotFoundException ex) {
            this.setEnabled(false);
            throw new InitializationException(String.format("RetireJS repo does not exist locally (%s)", repoFile), ex);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to initialize the RetireJS repo - data directory could not be created", ex);
        }
        try (FileInputStream in = new FileInputStream(repoFile);){
            this.jsRepository = new VulnerabilitiesRepositoryLoader().loadFromInputStream((InputStream)in);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to initialize the RetireJS repo", ex);
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.retirejs.enabled";
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        block31: {
            try {
                byte[] fileContent = IOUtils.toByteArray((InputStream)new FileInputStream(dependency.getActualFile()));
                ScannerFacade scanner = new ScannerFacade(this.jsRepository);
                List results = scanner.scanScript(dependency.getActualFile().getAbsolutePath(), fileContent, 0);
                if (results.size() > 0) {
                    for (JsLibraryResult libraryResult : results) {
                        JsLibrary lib = libraryResult.getLibrary();
                        dependency.setName(lib.getName());
                        dependency.setVersion(libraryResult.getDetectedVersion());
                        dependency.addEvidence(EvidenceType.VERSION, "file", "version", libraryResult.getDetectedVersion(), Confidence.HIGH);
                        dependency.addEvidence(EvidenceType.PRODUCT, "file", "name", libraryResult.getLibrary().getName(), Confidence.HIGH);
                        ArrayList<Vulnerability> vulns = new ArrayList<Vulnerability>();
                        JsVulnerability jsVuln = libraryResult.getVuln();
                        if (jsVuln.getIdentifiers().containsKey("CVE") || jsVuln.getIdentifiers().containsKey("osvdb")) {
                            for (Map.Entry entry : jsVuln.getIdentifiers().entrySet()) {
                                Vulnerability vuln;
                                String key = (String)entry.getKey();
                                List value = (List)entry.getValue();
                                if ("CVE".equals(key)) {
                                    for (String cve : value) {
                                        vuln = engine.getDatabase().getVulnerability(StringUtils.trim((String)cve));
                                        if (vuln == null) {
                                            vuln = new Vulnerability();
                                            vuln.setName(cve);
                                            vuln.setUnscoredSeverity(jsVuln.getSeverity());
                                            vuln.setSource(Vulnerability.Source.RETIREJS);
                                        }
                                        for (String info : jsVuln.getInfo()) {
                                            vuln.addReference("info", "info", info);
                                        }
                                        vulns.add(vuln);
                                    }
                                } else if ("osvdb".equals(key)) {
                                    for (String osvdb : value) {
                                        vuln = new Vulnerability();
                                        vuln.setName(osvdb);
                                        vuln.setSource(Vulnerability.Source.RETIREJS);
                                        vuln.setUnscoredSeverity(jsVuln.getSeverity());
                                        for (String info : jsVuln.getInfo()) {
                                            vuln.addReference("info", "info", info);
                                        }
                                        vulns.add(vuln);
                                    }
                                }
                                dependency.addVulnerabilities(vulns);
                            }
                            continue;
                        }
                        Vulnerability individualVuln = new Vulnerability();
                        for (Map.Entry entry : jsVuln.getIdentifiers().entrySet()) {
                            String key = (String)entry.getKey();
                            List value = (List)entry.getValue();
                            if (null != key) {
                                switch (key) {
                                    case "issue": {
                                        individualVuln.setName(libraryResult.getLibrary().getName() + " issue: " + (String)value.get(0));
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        break;
                                    }
                                    case "bug": {
                                        individualVuln.setName(libraryResult.getLibrary().getName() + " bug: " + (String)value.get(0));
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        break;
                                    }
                                    case "summary": {
                                        if (null == individualVuln.getName()) {
                                            individualVuln.setName((String)value.get(0));
                                        }
                                        individualVuln.setDescription((String)value.get(0));
                                        break;
                                    }
                                    case "release": {
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        break;
                                    }
                                }
                            }
                            individualVuln.setSource(Vulnerability.Source.RETIREJS);
                            individualVuln.setUnscoredSeverity(jsVuln.getSeverity());
                            for (String info : jsVuln.getInfo()) {
                                individualVuln.addReference("info", "info", info);
                            }
                        }
                        dependency.addVulnerability(individualVuln);
                    }
                    break block31;
                }
                if (this.getSettings().getBoolean("analyzer.retirejs.filternonvulnerable", false)) {
                    engine.removeDependency(dependency);
                }
            }
            catch (IOException | DatabaseException e) {
                throw new AnalysisException(e);
            }
        }
    }
}

