/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.central.CentralSearch;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CentralAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CentralAnalyzer.class);
    private static final String ANALYZER_NAME = "Central Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private static final int NUMBER_OF_TRIES = 5;
    private CentralSearch searcher;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();

    @Override
    public void initialize(Settings settings) {
        super.initialize(settings);
        this.setEnabled(this.checkEnabled());
    }

    private boolean checkEnabled() {
        boolean retVal = false;
        try {
            if (this.getSettings().getBoolean("analyzer.central.enabled")) {
                if (!this.getSettings().getBoolean("analyzer.nexus.enabled") || "https://repository.sonatype.org/service/local/".equals(this.getSettings().getString("analyzer.nexus.url"))) {
                    LOGGER.debug("Enabling the Central analyzer");
                    retVal = true;
                } else {
                    LOGGER.info("Nexus analyzer is enabled, disabling the Central Analyzer");
                }
            } else {
                LOGGER.info("Central analyzer disabled");
            }
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling the Central analyzer");
        }
        return retVal;
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing Central analyzer");
        LOGGER.debug("Central analyzer enabled: {}", (Object)this.isEnabled());
        if (this.isEnabled()) {
            try {
                this.searcher = new CentralSearch(this.getSettings());
            }
            catch (MalformedURLException ex) {
                this.setEnabled(false);
                throw new InitializationException("The configured URL to Maven Central is malformed", ex);
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.central.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        try {
            List<MavenArtifact> mas = this.fetchMavenArtifacts(dependency);
            Confidence confidence = mas.size() > 1 ? Confidence.HIGH : Confidence.HIGHEST;
            for (MavenArtifact ma : mas) {
                LOGGER.debug("Central analyzer found artifact ({}) for dependency ({})", (Object)ma, (Object)dependency.getFileName());
                dependency.addAsEvidence("central", ma, confidence);
                boolean pomAnalyzed = false;
                for (Evidence e : dependency.getEvidence(EvidenceType.VENDOR)) {
                    if (!"pom".equals(e.getSource())) continue;
                    pomAnalyzed = true;
                    break;
                }
                if (pomAnalyzed || ma.getPomUrl() == null) continue;
                File pomFile = null;
                try {
                    File baseDir = this.getSettings().getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        LOGGER.warn("Unable to fetch pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                        LOGGER.debug("Unable to delete temp file");
                    }
                    LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
                    Downloader downloader = new Downloader(this.getSettings());
                    downloader.fetchFile(new URL(ma.getPomUrl()), pomFile);
                    PomUtils.analyzePOM(dependency, pomFile);
                }
                catch (DownloadFailedException ex) {
                    LOGGER.warn("Unable to download pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                finally {
                    if (pomFile == null || !pomFile.exists() || FileUtils.deleteQuietly((File)pomFile)) continue;
                    LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile.toString());
                    pomFile.deleteOnExit();
                }
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info("invalid sha1-hash on {}", (Object)dependency.getFileName());
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Artifact not found in repository: '{}", (Object)dependency.getFileName());
        }
        catch (IOException ioe) {
            String message = "Could not connect to Central search. Analysis failed.";
            LOGGER.error("Could not connect to Central search. Analysis failed.", (Throwable)ioe);
            throw new AnalysisException("Could not connect to Central search. Analysis failed.", ioe);
        }
    }

    protected List<MavenArtifact> fetchMavenArtifacts(Dependency dependency) throws IOException {
        IOException lastException = null;
        long sleepingTimeBetweenRetriesInMillis = 1000L;
        int triesLeft = 5;
        while (triesLeft-- > 0) {
            try {
                return this.searcher.searchSha1(dependency.getSha1sum());
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                LOGGER.debug("Could not connect to Central search (tries left: {}): {}", (Object)triesLeft, (Object)ioe.getMessage());
                lastException = ioe;
                if (triesLeft <= 0) continue;
                try {
                    Thread.sleep(sleepingTimeBetweenRetriesInMillis);
                    sleepingTimeBetweenRetriesInMillis *= 2L;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        String message = "Finally failed connecting to Central search. Giving up after 5 tries.";
        throw new IOException("Finally failed connecting to Central search. Giving up after 5 tries.", lastException);
    }

    protected void setCentralSearch(CentralSearch searcher) {
        this.searcher = searcher;
    }
}

