/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.util.ArrayDeque;
import java.util.Deque;
import org.owasp.dependencycheck.xml.pom.License;
import org.owasp.dependencycheck.xml.pom.Model;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PomHandler
extends DefaultHandler {
    public static final String PROJECT = "project";
    public static final String GROUPID = "groupId";
    public static final String ARTIFACTID = "artifactId";
    public static final String VERSION = "version";
    public static final String PARENT = "parent";
    public static final String NAME = "name";
    public static final String ORGANIZATION = "organization";
    public static final String DESCRIPTION = "description";
    public static final String LICENSES = "licenses";
    public static final String LICENSE = "license";
    public static final String URL = "url";
    private final Model model = new Model();
    private final Deque<String> stack = new ArrayDeque<String>();
    private License license = null;
    private StringBuilder currentText;

    public Model getModel() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentText = new StringBuilder();
        this.stack.push(qName);
        if (LICENSE.equals(qName)) {
            this.license = new License();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack.pop();
        String parentNode = this.stack.peek();
        if (PROJECT.equals(parentNode)) {
            if (GROUPID.equals(qName)) {
                this.model.setGroupId(this.currentText.toString());
            } else if (ARTIFACTID.equals(qName)) {
                this.model.setArtifactId(this.currentText.toString());
            } else if (VERSION.equals(qName)) {
                this.model.setVersion(this.currentText.toString());
            } else if (NAME.equals(qName)) {
                this.model.setName(this.currentText.toString());
            } else if (ORGANIZATION.equals(qName)) {
                this.model.setOrganization(this.currentText.toString());
            } else if (DESCRIPTION.equals(qName)) {
                this.model.setDescription(this.currentText.toString());
            } else if (URL.equals(qName)) {
                this.model.setProjectURL(this.currentText.toString());
            }
        } else if (PARENT.equals(parentNode)) {
            if (GROUPID.equals(qName)) {
                this.model.setParentGroupId(this.currentText.toString());
            } else if (ARTIFACTID.equals(qName)) {
                this.model.setParentArtifactId(this.currentText.toString());
            } else if (VERSION.equals(qName)) {
                this.model.setParentVersion(this.currentText.toString());
            }
        } else if (LICENSE.equals(parentNode)) {
            if (this.license != null) {
                if (NAME.equals(qName)) {
                    this.license.setName(this.currentText.toString());
                } else if (URL.equals(qName)) {
                    this.license.setUrl(this.currentText.toString());
                }
            }
        } else if (LICENSES.equals(parentNode) && LICENSE.equals(qName) && this.license != null) {
            this.model.addLicense(this.license);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }
}

