/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeTool.class);

    public String url(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("UTF-8 is not supported?");
            LOGGER.info("", (Throwable)ex);
            return "";
        }
    }

    public String html(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeHtml4((String)text);
    }

    public String xml(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeXml11((String)text);
    }
}

