/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NexusSearch {
    private final URL rootURL;
    private final boolean useProxy;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusSearch.class);

    public NexusSearch(URL rootURL, boolean useProxy) {
        this.rootURL = rootURL;
        this.useProxy = useProxy;
        LOGGER.debug("Using proxy: {}", (Object)useProxy);
    }

    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        URL url = new URL(this.rootURL, String.format("identify/sha1/%s", sha1.toLowerCase()));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection((URL)url, (boolean)this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        switch (conn.getResponseCode()) {
            case 200: {
                try {
                    DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
                    Document doc = builder.parse(conn.getInputStream());
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    String groupId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/groupId", doc);
                    String artifactId = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactId", doc);
                    String version = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/version", doc);
                    String link = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/artifactLink", doc);
                    String pomLink = xpath.evaluate("/org.sonatype.nexus.rest.model.NexusArtifact/pomLink", doc);
                    MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
                    if (link != null && !link.isEmpty()) {
                        ma.setArtifactUrl(link);
                    }
                    if (pomLink != null && !pomLink.isEmpty()) {
                        ma.setPomUrl(pomLink);
                    }
                    return ma;
                }
                catch (Throwable e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            case 404: {
                throw new FileNotFoundException("Artifact not found in Nexus");
            }
        }
        LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
        throw new IOException("Could not connect to Nexus");
    }

    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "status");
            HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection((URL)url, (boolean)this.useProxy);
            conn.addRequestProperty("Accept", "application/xml");
            conn.connect();
            if (conn.getResponseCode() != 200) {
                LOGGER.warn("Expected 200 result from Nexus, got {}", (Object)conn.getResponseCode());
                return false;
            }
            DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
            Document doc = builder.parse(conn.getInputStream());
            if (!"status".equals(doc.getDocumentElement().getNodeName())) {
                LOGGER.warn("Expected root node name of status, got {}", (Object)doc.getDocumentElement().getNodeName());
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }
}

