/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyMergingAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyMergingAnalyzer.class);
    private boolean analyzed = false;
    private static final String ANALYZER_NAME = "Dependency Merging Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_INFORMATION_COLLECTION;

    protected boolean getAnalyzed() {
        return this.analyzed;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public boolean supportsParallelProcessing() {
        return false;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.dependencymerging.enabled";
    }

    @Override
    protected synchronized void analyzeDependency(Dependency ignore, Engine engine) throws AnalysisException {
        if (!this.analyzed) {
            this.analyzed = true;
            HashSet<Dependency> dependenciesToRemove = new HashSet<Dependency>();
            ListIterator<Dependency> mainIterator = engine.getDependencies().listIterator();
            block0: while (mainIterator.hasNext()) {
                Dependency dependency = mainIterator.next();
                if (!mainIterator.hasNext() || dependenciesToRemove.contains(dependency)) continue;
                ListIterator<Dependency> subIterator = engine.getDependencies().listIterator(mainIterator.nextIndex());
                while (subIterator.hasNext()) {
                    Dependency nextDependency = subIterator.next();
                    Dependency main = null;
                    main = this.getMainGemspecDependency(dependency, nextDependency);
                    if (main != null) {
                        if (main == dependency) {
                            this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                            continue;
                        }
                        this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                        continue block0;
                    }
                    main = this.getMainSwiftDependency(dependency, nextDependency);
                    if (main == null) continue;
                    if (main == dependency) {
                        this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                        continue;
                    }
                    this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                    continue block0;
                }
            }
            engine.getDependencies().removeAll(dependenciesToRemove);
        }
    }

    private void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        LOGGER.debug("Merging '{}' into '{}'", (Object)relatedDependency.getFilePath(), (Object)dependency.getFilePath());
        dependency.addRelatedDependency(relatedDependency);
        dependency.getVendorEvidence().getEvidence().addAll(relatedDependency.getVendorEvidence().getEvidence());
        dependency.getProductEvidence().getEvidence().addAll(relatedDependency.getProductEvidence().getEvidence());
        dependency.getVersionEvidence().getEvidence().addAll(relatedDependency.getVersionEvidence().getEvidence());
        Iterator<Dependency> i = relatedDependency.getRelatedDependencies().iterator();
        while (i.hasNext()) {
            dependency.addRelatedDependency(i.next());
            i.remove();
        }
        if (dependency.getSha1sum().equals(relatedDependency.getSha1sum())) {
            dependency.addAllProjectReferences(relatedDependency.getProjectReferences());
        }
        dependenciesToRemove.add(relatedDependency);
    }

    private boolean isSameRubyGem(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".gemspec") || !dependency2.getFileName().endsWith(".gemspec") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    private Dependency getMainGemspecDependency(Dependency dependency1, Dependency dependency2) {
        if (this.isSameRubyGem(dependency1, dependency2)) {
            File lFile = dependency1.getActualFile();
            File left = lFile.getParentFile();
            if (left != null && left.getName().equalsIgnoreCase("specifications")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }

    private boolean isSameSwiftPackage(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".podspec") && !dependency1.getFileName().equals("Package.swift") || !dependency2.getFileName().endsWith(".podspec") && !dependency2.getFileName().equals("Package.swift") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    private Dependency getMainSwiftDependency(Dependency dependency1, Dependency dependency2) {
        if (this.isSameSwiftPackage(dependency1, dependency2)) {
            if (dependency1.getFileName().endsWith(".podspec")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }
}

