/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.client.intern;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Stack;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBundleContextClientImpl
implements RemoteBundleContextClient {
    private static final String PROBE_SIGNATURE_KEY = "Probe-Signature";
    private RemoteBundleContext m_remoteBundleContext = null;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteBundleContextClient.class);
    private final RelativeTimeout m_rmiLookupTimeout;
    private final Integer m_registry;
    private final Stack<Long> m_installed;
    private final String m_name;

    public RemoteBundleContextClientImpl(String name, Integer registry, RelativeTimeout timeout) {
        assert (registry != null) : "registry should not be null";
        this.m_registry = registry;
        this.m_name = name;
        this.m_rmiLookupTimeout = timeout;
        this.m_installed = new Stack();
    }

    private <T> T getService(Class<T> serviceType, final String filter, final RelativeTimeout timeout) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceType}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
                try {
                    return RemoteBundleContextClientImpl.this.getRemoteBundleContext().remoteCall(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), filter, timeout, params);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                catch (RemoteException e) {
                    throw new RuntimeException("Remote exception", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invocation exception", e);
                }
            }
        });
    }

    @Override
    public long install(String location, InputStream stream) {
        try {
            byte[] packed = this.pack(stream);
            long id = this.getRemoteBundleContext().installBundle(location, packed);
            this.m_installed.push(id);
            this.getRemoteBundleContext().startBundle(id);
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Bundle cannot be installed", e);
        }
    }

    private byte[] pack(InputStream stream) {
        LOG.debug("Packing probe into memory for true RMI. Hopefully things will fill in..");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StreamUtils.copyStream((InputStream)stream, (OutputStream)out, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    @Override
    public void cleanup() {
        try {
            while (!this.m_installed.isEmpty()) {
                Long id = this.m_installed.pop();
                this.getRemoteBundleContext().uninstallBundle(id.longValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Bundle cannot be uninstalled", e);
        }
    }

    @Override
    public void setBundleStartLevel(long bundleId, int startLevel) {
        try {
            this.getRemoteBundleContext().setBundleStartLevel(bundleId, startLevel);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote exception", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Start level cannot be set", e);
        }
    }

    @Override
    public void start() {
        try {
            this.getRemoteBundleContext().startBundle(0L);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote exception", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("System bundle cannot be started", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.getRemoteBundleContext().stopBundle(0L);
        }
        catch (RemoteException e) {
        }
        catch (BundleException e) {
            throw new RuntimeException("System bundle cannot be stopped", e);
        }
    }

    @Override
    public void waitForState(long bundleId, int state, RelativeTimeout timeout) {
        try {
            this.getRemoteBundleContext().waitForState(bundleId, state, timeout);
        }
        catch (RemoteException e) {
            throw new RuntimeException("waitForState", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("waitForState", e);
        }
    }

    private synchronized RemoteBundleContext getRemoteBundleContext() {
        if (this.m_remoteBundleContext == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            LOG.info("Waiting for remote bundle context.. on " + this.m_registry + " name: " + this.m_name + " timout: " + this.m_rmiLookupTimeout);
            Exception reason = null;
            long startedTrying = System.currentTimeMillis();
            try {
                do {
                    try {
                        Registry reg = LocateRegistry.getRegistry(this.m_registry);
                        this.m_remoteBundleContext = (RemoteBundleContext)reg.lookup(this.m_name);
                    }
                    catch (Exception e) {
                        reason = e;
                    }
                } while (this.m_remoteBundleContext == null && (this.m_rmiLookupTimeout.isNoTimeout() || System.currentTimeMillis() < startedTrying + this.m_rmiLookupTimeout.getValue()));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.m_remoteBundleContext == null) {
                throw new RuntimeException("Cannot get the remote bundle context", reason);
            }
            LOG.debug("Remote bundle context found after " + (System.currentTimeMillis() - startedTrying) + " millis");
        }
        return this.m_remoteBundleContext;
    }

    @Override
    public void call(TestAddress address) {
        String filterExpression = "(Probe-Signature=" + address.root().identifier() + ")";
        ProbeInvoker service = this.getService(ProbeInvoker.class, filterExpression, this.m_rmiLookupTimeout);
        service.call(address.arguments());
    }

    public String getName() {
        return this.m_name;
    }
}

