/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class PatternCaptureTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> patterns;
    private final boolean preserveOriginal;
    public static final JsonpDeserializer<PatternCaptureTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternCaptureTokenFilter::setupPatternCaptureTokenFilterDeserializer);

    private PatternCaptureTokenFilter(Builder builder) {
        super(builder);
        this.patterns = ApiTypeHelper.unmodifiableRequired(builder.patterns, (Object)this, "patterns");
        this.preserveOriginal = ApiTypeHelper.requireNonNull(builder.preserveOriginal, this, "preserveOriginal");
    }

    public static PatternCaptureTokenFilter of(Function<Builder, ObjectBuilder<PatternCaptureTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.PatternCapture;
    }

    public final List<String> patterns() {
        return this.patterns;
    }

    public final boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_capture");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.patterns)) {
            generator.writeKey("patterns");
            generator.writeStartArray();
            for (String item0 : this.patterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
    }

    protected static void setupPatternCaptureTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternCaptureTokenFilter> {
        private List<String> patterns;
        private Boolean preserveOriginal;

        public final Builder patterns(List<String> list) {
            this.patterns = Builder._listAddAll(this.patterns, list);
            return this;
        }

        public final Builder patterns(String value, String ... values) {
            this.patterns = Builder._listAdd(this.patterns, value, values);
            return this;
        }

        public final Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternCaptureTokenFilter build() {
            this._checkSingleUse();
            return new PatternCaptureTokenFilter(this);
        }
    }
}

