/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.DeleteKey;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public class SetupJavaCaching
extends Recipe {
    public String getDisplayName() {
        return "Setup Java dependency caching";
    }

    public String getDescription() {
        return "GitHub actions supports dependency caching on Maven and Gradle projects. See the [blog post](https://github.blog/changelog/2021-08-30-github-actions-setup-java-now-supports-dependency-caching/).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new YamlVisitor<ExecutionContext>(){

            public Yaml visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                Yaml.Documents d = documents;
                if (!FindKey.find((Yaml)documents, (String)"$.jobs..steps[?(@.run =~ '.*gradle.*')]").isEmpty()) {
                    d = (Yaml.Documents)new MergeYaml("$.jobs..steps[?(@.uses =~ 'actions/setup-java(?:@v.+)?')]", "with:\n  cache: 'gradle'", Boolean.valueOf(true), null, null, null, null, null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                }
                if (!FindKey.find((Yaml)documents, (String)"$.jobs..steps[?(@.run =~ '.*mvn.*')]").isEmpty()) {
                    d = (Yaml.Documents)new MergeYaml("$.jobs..steps[?(@.uses =~ 'actions/setup-java(?:@v.+)?')]", "with:\n  cache: 'maven'", Boolean.valueOf(true), null, null, null, null, null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                }
                if (d != documents) {
                    d = (Yaml.Documents)new DeleteKey("$.jobs..steps[?(@.uses =~ 'actions/cache(?:@v.+)?')]", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                }
                return d;
            }
        });
    }
}

