/*
 * #%L
 * Wikitty :: ui-zk
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.FieldType.TYPE;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;

/**
 *
 * @author sherkhan
 */
public class WikittyForm {

    protected FormModel _formModel = new FormModel();
    protected List<WikittyExtension> _holdExtensions = new ArrayList<WikittyExtension>();
    protected Wikitty _wikitty = null;

    public void createModelFieldExtensions() {
        List<FieldExtension> fieldExtensions = new ArrayList<FieldExtension>();
        for (WikittyExtension wikittyExtension : _holdExtensions) {
            Collection<String> extensionNames = wikittyExtension.getFieldNames();
            for (String name : extensionNames) {
                FieldType fieldType = wikittyExtension.getFieldType(name);
                FieldExtension fieldExtension = new FieldExtension(fieldType, name, wikittyExtension);
                fieldExtensions.add(fieldExtension);
            }
        }
        _formModel.setFieldExtensions(fieldExtensions);
    }

    List<Component> getComponentsByWikittyDateType(FieldExtension fieldExtension) {
        List<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (_wikitty != null && _wikitty.hasExtension(wikittyExtensionName)) {
            Date obj = _wikitty.getFieldAsDate(wikittyExtensionName, fieldExtension.getName());
            if (obj != null) {
                if (fieldType.isCollection()) {
                    List<Date> dates = _wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), Date.class);
                    for (Date date : dates) {
                        components.add(new Datebox(date));
                    }
                } else {
                    components.add(new Datebox(obj));
                }
                return components;
            }
        }
        components.add(new Datebox());
        return components;
    }

    List<Component> getComponentsByWikittyNumericType(FieldExtension fieldExtension) {
        List<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (_wikitty != null && _wikitty.hasExtension(wikittyExtensionName)) {
            BigDecimal obj = _wikitty.getFieldAsBigDecimal(wikittyExtensionName, fieldExtension.getName());
            if (obj != null) {
                if (fieldType.isCollection()) {
                    List<BigDecimal> decimals = _wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), BigDecimal.class);
                    for (BigDecimal decimal : decimals) {
                        components.add(new Decimalbox(decimal));
                    }
                } else {
                    components.add(new Decimalbox(obj));
                }
                return components;
            }
        }
        components.add(new Decimalbox());
        return components;
    }

    List<Component> getComponentsByWikittyStringType(FieldExtension fieldExtension) {
        List<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (_wikitty != null && _wikitty.hasExtension(wikittyExtensionName)) {
            String obj = _wikitty.getFieldAsString(wikittyExtensionName, fieldExtension.getName());
            if (obj != null) {
                if (fieldType.isCollection()) {
                    List<String> strings = _wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), String.class);
                    for (String str : strings) {
                        components.add(new Textbox(str));
                    }
                } else {
                    components.add(new Textbox(obj));
                }
                return components;
            }
        }
        components.add(new Textbox());
        return components;
    }

    List<Component> getComponentsByWikittyBooleanType(FieldExtension fieldExtension) {
        List<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (_wikitty != null && _wikitty.hasExtension(wikittyExtensionName)) {
            Boolean obj = _wikitty.getFieldAsBoolean(wikittyExtensionName, fieldExtension.getName());
            if (obj != null) {
                if (fieldType.isCollection()) {
                    List<Boolean> bools = _wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), Boolean.class);
                    for (Boolean bool : bools) {
                        Checkbox newCheckBox = new Checkbox();
                        newCheckBox.setChecked(bool);
                        components.add(newCheckBox);
                    }
                } else {
                    Checkbox newCheckBox = new Checkbox();
                    newCheckBox.setChecked(obj);
                    components.add(newCheckBox);
                }
                return components;
            }
        }
        components.add(new Checkbox());
        return components;
    }

    protected List<Date> getSetDateByCell(Listcell cell) {
        List<Date> dates = new ArrayList<Date>();
        List<Datebox> children = cell.getChildren();
        for (Datebox dateBox : children) {
            Date newDate = dateBox.getValue();
            dates.add(newDate);
        }
        return dates;
    }

    protected List<BigDecimal> getSetNumByCell(Listcell cell) {
        List<BigDecimal> nums = new ArrayList<BigDecimal>();
        List<Decimalbox> children = cell.getChildren();
        for (Decimalbox decimal : children) {
            BigDecimal newDecimal = decimal.getValue();
            nums.add(newDecimal);
        }
        return nums;
    }

    protected List<String> getSetStringByCell(Listcell cell) {
        List<String> strings = new ArrayList<String>();
        List<Textbox> children = cell.getChildren();
        for (Textbox textBox : children) {
            String newString = textBox.getValue();
            strings.add(newString);
        }
        return strings;
    }

    protected List<Boolean> getSetBoolByCell(Listcell cell) {
        List<Boolean> booleans = new ArrayList<Boolean>();
        List<Checkbox> children = cell.getChildren();
        for (Checkbox checkBox : children) {
            Boolean newBoolean = checkBox.isChecked();
            booleans.add(newBoolean);
        }
        return booleans;
    }

    public Wikitty retriveWikittyInForm(Listbox formListBox, Wikitty newWikitty) {
        if (newWikitty == null) {
            newWikitty = _wikitty;
        }
        newWikitty.addExtension(_holdExtensions);
        List<Listitem> items = formListBox.getItems();
        for (Listitem item : items) {
            FieldExtension fieldExtension = (FieldExtension) item.getValue();
            String extensionName = fieldExtension.getWikittyExtension().getName();
            FieldType fieldType = fieldExtension.getFieldType();
            String fieldName = fieldExtension.getName();
            String id = extensionName + "." + fieldName;
            Listcell cell = (Listcell) item.getFellowIfAny(id);
            TYPE type = fieldType.getType();
            List collection = null;
            if (type == TYPE.DATE) {
                collection = getSetDateByCell(cell);
            } else if (type == TYPE.NUMERIC) {
                collection = getSetNumByCell(cell);
            } else if (type == TYPE.STRING) {
                collection = getSetStringByCell(cell);
            } else if (type == TYPE.BOOLEAN) {
                collection = getSetBoolByCell(cell);
            }
            if (fieldType.isCollection()) {
                if (_wikitty != null) {
                    newWikitty.clearField(extensionName, fieldName);
                }
                for (Object obj : collection) {
                    newWikitty.addToField(extensionName, fieldName, obj);
                }
            } else {
                newWikitty.setField(extensionName, fieldName, collection.get(0));
            }
        }
        return newWikitty;
    }

    public void deleteInput(Listbox formListBox) {
        Listitem item = formListBox.getSelectedItem();
        if (item != null) {
            FieldExtension fieldExtension = (FieldExtension) item.getValue();
            FieldType fieldType = fieldExtension.getFieldType();
            if (fieldType.isCollection()) {
                String extensionName = fieldExtension.getWikittyExtension().getName();
                String fieldName = fieldExtension.getName();
                String id = extensionName + "." + fieldName;
                Listcell cell = (Listcell) item.getFellowIfAny(id);
                if (cell != null) {
                    List children = cell.getChildren();
                    if (children.size() > 1) {
                        children.remove(children.size() - 1);
                    }
                }
            }
        }
    }

    public void addNewInput(Listbox formListBox) {
        Listitem item = formListBox.getSelectedItem();
        if (item != null) {
            FieldExtension fieldExtension = (FieldExtension) item.getValue();
            FieldType fieldType = fieldExtension.getFieldType();
            if (fieldType.isCollection()) {
                String extensionName = fieldExtension.getWikittyExtension().getName();
                String fieldName = fieldExtension.getName();
                String id = extensionName + "." + fieldName;
                Listcell cell = (Listcell) item.getFellowIfAny(id);
                if (cell != null) {
                    Component comp = cell.getFirstChild();
                    cell.appendChild((Component) comp.clone());
                }
            }
        }
    }

    public boolean isSelected() {
        if (_wikitty == null) {
            return false;
        }
        return true;
    }

    public void addExtension(WikittyExtension newExtension) {
        if (newExtension != null) {
            if (!_holdExtensions.contains(newExtension)) {
                boolean bool = false;
                String extensionName = newExtension.getName();
                for (WikittyExtension extension : _holdExtensions) {
                    if (extensionName.equals(extension.getName())) {
                        bool = true;
                        break;
                    }
                }
                if (!bool) {
                    _holdExtensions.add(newExtension);
                    createModelFieldExtensions();
                }
            }
        }
    }

    public void removeExtension(WikittyExtension removeExtension) {
//        if (_wikitty != null && removeExtension != null) {
//            String name = removeExtension.getName();
//            if (_wikitty.hasExtension(name) == true) {
//                _wikitty.
//            }
//        }
    }


    /*
     * Renderer
     */
    public ListitemRenderer getFieldExtensionRenderer() {
        return new ListitemRenderer() {

            @Override
            public void render(Listitem item, Object data) throws Exception {
                item.setValue(data);
                FieldExtension fieldExtension = (FieldExtension) data;
                FieldType fieldType = fieldExtension.getFieldType();
                TYPE type = fieldType.getType();
                List<Component> components = new ArrayList<Component>();
                if (type == TYPE.DATE) {
                    components = getComponentsByWikittyDateType(fieldExtension);
                } else if (type == TYPE.NUMERIC) {
                    components = getComponentsByWikittyNumericType(fieldExtension);
                } else if (type == TYPE.STRING) {
                    components = getComponentsByWikittyStringType(fieldExtension);
                } else if (type == TYPE.BOOLEAN) {
                    components = getComponentsByWikittyBooleanType(fieldExtension);
                }
                Listcell cell1 = new Listcell("(" + fieldExtension.getWikittyExtension().getName() + ")");
                String fieldName = fieldExtension.getName();
                if (fieldType.isCollection()) {
                    fieldName += " (Multiple field)";
                }
                Listcell cell2 = new Listcell(fieldName);
                Listcell cell3 = new Listcell();
                String id = fieldExtension.getWikittyExtension().getName() + "." + fieldExtension.getName();
                cell3.setId(id);
                for (Component component : components) {
                    cell3.appendChild(component);
                }
                item.appendChild(cell1);
                item.appendChild(cell2);
                item.appendChild(cell3);
            }
        };
    }

    /*
     * Setters
     */
    public void setHoldExtensions(List<WikittyExtension> holdExtensions) {
        _wikitty = null;
        _holdExtensions = holdExtensions;
        createModelFieldExtensions();
    }

    public void setHoldExtensions(WikittyExtension holdExtension) {
        _wikitty = null;
        _holdExtensions.clear();
        _holdExtensions.add(holdExtension);
        createModelFieldExtensions();
    }

    public void setWikitty(Wikitty wikitty) {
        _wikitty = wikitty;
        if (wikitty != null) {
            _holdExtensions = new ArrayList<WikittyExtension>(_wikitty.getExtensions());
            createModelFieldExtensions();
        }
    }

    /*
     * Getters
     */
    public List<WikittyExtension> getHoldExtensions() {
        return _holdExtensions;
    }

    public FormModel getFormModel() {
        return _formModel;
    }

    public Wikitty getWikitty() {
        return _wikitty;
    }
}
