/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyTypes;

public abstract class AbstractWikittyEditAction
extends ActionSupport {
    private static final long serialVersionUID = 1959245739866183821L;
    private static final Log log = LogFactory.getLog(AbstractWikittyEditAction.class);
    public static final String PREFIX_WIKITTY = "Wikitty";

    public String execute() throws Exception {
        String id = this.getArgument("id", "");
        String redirect = this.getArgument("redirect", "");
        String delete = this.getArgument("delete", "");
        String store = this.getArgument("store", "");
        WikittyProxy proxy = this.getProxy();
        if (!StringUtils.isEmpty((CharSequence)delete)) {
            proxy.delete(id);
        } else if (!StringUtils.isEmpty((CharSequence)store)) {
            Map param = ActionContext.getContext().getParameters();
            Map<String, Object> wikittyFieldMap = this.formatArgs(param);
            Wikitty wikitty = proxy.restore(id);
            if (wikitty != null) {
                for (Map.Entry<String, Object> entry : wikittyFieldMap.entrySet()) {
                    FieldType ftype = wikitty.getFieldType(entry.getKey());
                    ArrayList<String> value = entry.getValue();
                    if (ftype.isCollection() && ftype.getType() == WikittyTypes.STRING && value != null) {
                        String[] valuesString;
                        String valueString = ((Object)value).toString();
                        valueString = new String(valueString.substring(1, valueString.length() - 1));
                        ArrayList<String> list = new ArrayList<String>();
                        for (String element : valuesString = StringUtil.split((String)valueString, (String)",")) {
                            list.add(element.trim());
                        }
                        value = list;
                    }
                    wikitty.setFqField(entry.getKey(), (Object)value);
                }
            }
            proxy.store(wikitty);
        }
        return "success";
    }

    public abstract WikittyProxy getProxy();

    protected Map<String, Object> formatArgs(Map<String, Object> args) {
        HashMap<String, Object> wikittyFieldMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> en : args.entrySet()) {
            if (!en.getKey().startsWith(PREFIX_WIKITTY)) continue;
            String value = "";
            if (en.getValue() instanceof String[]) {
                for (String occu : (String[])en.getValue()) {
                    value = value + occu;
                }
            } else {
                value = String.valueOf(en.getValue());
            }
            wikittyFieldMap.put(en.getKey(), value);
        }
        return wikittyFieldMap;
    }

    public String getArgument(String key, String defaultValue) {
        Object temp = ActionContext.getContext().getParameters().get(key);
        String result = "";
        if (temp == null) {
            result = defaultValue;
        } else if (temp instanceof String[]) {
            for (String t : (String[])temp) {
                result = result + t;
            }
        } else {
            result = temp.toString();
        }
        return result;
    }
}

