/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.AbstractReplicationEngineTest;
import org.nuiton.topia.replication.ReplicationEngine;
import org.nuiton.topia.replication.ReplicationEngineTest;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonImpl;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetImpl;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceImpl;

public class ReplicationEngineAllTest
extends AbstractReplicationEngineTest {
    private static final Log log = LogFactory.getLog(ReplicationEngineTest.class);
    protected static final TopiaEntityEnum[] contracts = new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race};
    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();
    protected static Person person;
    protected static Person person2;
    protected static Pet pet;
    protected static Pet pet2;
    protected static Pet pet3;
    protected static Race race;
    protected static Race race2;
    protected static Race race3;

    @AfterClass
    public static void after() throws Exception {
        AbstractReplicationEngineTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        person = this.update(person);
        person2 = this.update(person2);
        pet = this.update(pet);
        pet2 = this.update(pet2);
        race = this.update(race);
        race2 = this.update(race2);
        race3 = this.update(race3);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.dstCtxt != null && !this.dstCtxt.isClosed()) {
            this.dstCtxt.closeContext();
        }
    }

    @Override
    @Test
    public void testDetectTypes() throws Exception {
        this.detectTypes((TopiaEntity)race, Race.class);
        this.detectTypes((TopiaEntity)pet, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)person, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)pet2, Pet.class);
        this.detectTypes((TopiaEntity)person2, Person.class);
        this.detectTypes((TopiaEntity)race2, Race.class);
        this.detectTypes((TopiaEntity)race3, Race.class);
        this.detectTypes((TopiaEntity)pet3, Pet.class, Race.class);
    }

    @Override
    @Test
    public void testGetOperation() throws Exception {
    }

    @Override
    @Test
    public void testDetectAssociations() throws Exception {
        this.detectAssociations((TopiaEntity)person, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, "pet");
        this.detectAssociations((TopiaEntity)race, new Object[0]);
        this.detectAssociations((TopiaEntity)pet, new Object[0]);
        this.detectAssociations((TopiaEntity)person2, new Object[0]);
        this.detectAssociations((TopiaEntity)race2, new Object[0]);
        this.detectAssociations((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectDirectDependencies() throws Exception {
        this.detectDirectDependencies((TopiaEntity)person, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, "person", TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, "race");
        this.detectDirectDependencies((TopiaEntity)person2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectShell() throws Exception {
        this.detectShell((TopiaEntity)person, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
        this.detectShell((TopiaEntity)race, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
        this.detectShell((TopiaEntity)person2, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
        this.detectShell((TopiaEntity)race2, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet2, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
    }

    @Override
    @Test
    public void testDetectDependencies() throws Exception {
        this.detectDependencies(null, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Race}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Person}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Pet}});
    }

    @Override
    @Test
    public void testDetectObjectsToDettach() throws Exception {
        this.detectObjectsToDettach(null, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new String[]{"pet"});
    }

    @Override
    @Test
    public void testDetectOperations() throws Exception {
        this.detectOperations(null, new Object[0]);
    }

    @Override
    @Test
    public void testDoReplicate() throws Exception {
        this.doReplicateAll();
    }

    @Override
    protected TopiaContext createDb(String name) throws Exception {
        File localDB = new File(this.getTestDir(((Object)((Object)this)).getClass()), "db_" + name);
        Properties config = this.getH2Properties(localDB);
        context = TopiaContextFactory.getContext((Properties)config);
        TopiaContextImplementor tx = (TopiaContextImplementor)context.beginTransaction();
        person = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding master"});
        race = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race I"});
        pet = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding", "person", person, "race", race});
        person2 = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding II master"});
        pet2 = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding II"});
        race2 = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race II"});
        race3 = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race III"});
        pet3 = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding III", "race", race3});
        tx.commitTransaction();
        tx.closeContext();
        return context;
    }

    @Override
    protected TopiaContext createDb2(String name) throws Exception {
        File localDB = new File(this.getTestDir(((Object)((Object)this)).getClass()), "db_" + name);
        Properties config = this.getH2Properties(localDB);
        return TopiaContextFactory.getContext((Properties)config);
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Properties getH2Properties(File f) {
        Properties config = new Properties();
        config.setProperty("hibernate.show_sql", "false");
        config.setProperty("hibernate.hbm2ddl.auto", "create");
        config.setProperty("topia.persistence.classes", entitiesList);
        config.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        config.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        config.setProperty("hibernate.connection.url", "jdbc:h2:file:" + f.getAbsolutePath() + ";create=true");
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");
        config.setProperty("topia.service.replication", ReplicationEngine.class.getName());
        return config;
    }

    @Override
    protected void createModel(TopiaEntity entity) throws TopiaException {
        this.model = this.service.createModelForAll(this.getContracts());
    }

    @Override
    protected void prepareModel(String ... ids) throws TopiaException {
        this.model = this.service.prepareForAll(this.getContracts());
    }
}

