/*
 * #%L
 * 
 * 
 * $Id: TopiaEntityContextable.java 2741 2013-07-05 15:29:40Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-1/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntityContextable.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * {@link TopiaEntity} with {@link TopiaContext} support (injected by
 * {@link TopiaContext} into entities).
 *
 * @author chatellier
 * @version $Revision: 2741 $
 *          <p/>
 *          Last update : $Date: 2013-07-05 17:29:40 +0200 (Fri, 05 Jul 2013) $
 *          By : $Author: athimel $
 */
public interface TopiaEntityContextable extends TopiaEntity {

    String PROPERTY_TOPIA_CONTEXT = "topiaContext";

    /** @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntityContextable#PROPERTY_TOPIA_CONTEXT} instead */
    @Deprecated
    String TOPIA_CONTEXT = PROPERTY_TOPIA_CONTEXT;

    /**
     * Set topia context.
     *
     * @param topiaContext topia context
     * @throws TopiaException if current topia entity context is not null
     */
    void setTopiaContext(TopiaContext topiaContext) throws TopiaException;

    /**
     * Get topia context.
     *
     * @return topia context
     */
    TopiaContext getTopiaContext();

    /**
     * Update entity in persistence context.
     */
    void update();

    /**
     * Delete entity in persistence context.
     */
    void delete();

}
