package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.builder.ToStringBuilder;


public abstract class Siege {

    protected final PropertyChangeSupport pcs;
    public int noSerie;
    public Voiture voiture;
    /**
     * Siege :
     */

    public Siege() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    /**
     * getNoSerie :
     * @return int 
     */

    public int getNoSerie() {
        return this.noSerie;
    }

    /**
     * setNoSerie :
     * @param newValue 
     */

    public void setNoSerie(int newValue) {
        int oldValue = getNoSerie();
        this.noSerie = newValue;
        firePropertyChange("noSerie", oldValue, newValue);
    }

    /**
     * getVoiture :
     * @return Voiture 
     */

    public Voiture getVoiture() {
        return this.voiture;
    }

    /**
     * setVoiture :
     * @param newValue 
     */

    public void setVoiture(Voiture newValue) {
        Voiture oldValue = getVoiture();
        this.voiture = newValue;
        firePropertyChange("voiture", oldValue, newValue);
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this)
		.append("noSerie", this.noSerie)
		.append("voiture", this.voiture).
                toString();
        return result;
    }


} //Siege
