/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/*******************************************************************************
 * TopiaEntityAbstract.java
 * 
 * Created: 28 déc. 2005 22:50:42
 * 
 * @author poussin
 * 
 * @version $Revision: 1558 $
 * 
 * Last update: $Date: 2009-06-11 06:53:44 +0200 (jeu. 11 juin 2009) $ by : $Author: tchemit $
 */

package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Classe de base de toutes les entités, cela permet de concentrer le code
 * technique dans cette classe. L'identifiant peut-etre n'importe quoi Aucune
 * restriction n'est faite dessus, il peut meme changer entre deux types
 * d'entité si cela ne pose pas d'autre probleme (heritage entre ces entités).
 * 
 * @author poussin
 */
public abstract class TopiaEntityAbstract implements TopiaEntity, Serializable {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(TopiaEntityAbstract.class);

    protected String topiaId;

    protected long topiaVersion;

    protected Date topiaCreateDate = new Date();

    transient protected TopiaContext topiaContext = null;

    transient protected VetoableChangeSupport readVetoables = new VetoableChangeSupport(
            this);
    transient protected PropertyChangeSupport readListeners = new PropertyChangeSupport(
            this);
    transient protected VetoableChangeSupport writeVetoables = new VetoableChangeSupport(
            this);
    transient protected PropertyChangeSupport writeListeners = new PropertyChangeSupport(
            this);

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#getTopiaId()
     */
    @Override
    public String getTopiaId() {
        return topiaId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#setTopiaId(String)
     */
    @Override
    public void setTopiaId(String v) {
        this.topiaId = v;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#getTopiaVersion()
     */
    @Override
    public long getTopiaVersion() {
        return topiaVersion;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#setTopiaVersion(long)
     */
    @Override
    public void setTopiaVersion(long v) {
        this.topiaVersion = v;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#getTopiaCreateTime()
     */
    @Override
    public Date getTopiaCreateDate() {
        return topiaCreateDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#setTopiaCreateTime(java.util.Date)
     */
    @Override
    public void setTopiaCreateDate(Date topiaCreateDate) {
        this.topiaCreateDate = topiaCreateDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#getTopiaContext()
     */
    @Override
    public TopiaContext getTopiaContext() {
        return topiaContext;
    }

    /**
     * @param context The context to set.
     * @throws TopiaException  if any pb ?
     */
    public void setTopiaContext(TopiaContext context) throws TopiaException {
        if (this.topiaContext == null) {
            this.topiaContext = context;
        } else {
            throw new TopiaException("Remplacement du contexte interdit");
        }
    }

    @Override
    public void postCreate() throws TopiaException {
        // do nothing by default
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#update()
     */
    @Override
    public void update() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.persistence.TopiaEntity#delete()
     */
    @Override
    public void delete() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.persistence.TopiaEntity#getComposite()
     */
    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.persistence.TopiaEntity#getAggregate()
     */
    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException();
    }

    /**
     * On utilise la date de creation comme hash code, cette date ne varie pas
     * au cours du temps
     */
    @Override
    public int hashCode() {
        int result = getTopiaCreateDate().hashCode();
        return result;
    }

    /**
     * On est sur que les objets sont bien les memes car s'il n'ont pas d'id
     * cela veut dire qu'il ne vienne pas de la meme session donc qu'il sont
     * nouveau et different, ou bien qu'ils viennent de la meme session et dans
     * ce cas l'egalite == fonctionne.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TopiaEntity == false) {
            return false;
        }
        TopiaEntity other = (TopiaEntity) obj;
        if (getTopiaId() == null || other.getTopiaId() == null) {
            return false;
        }
        boolean result = getTopiaId().equals(other.getTopiaId());
        return result;
    }

    protected void fireOnPreRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreRead(readVetoables,
                    this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(readListeners,
                    this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, int index, Object value) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostRead(readListeners,
                    this, propertyName, index, value);
        }
    }

    protected void fireOnPreWrite(String propertyName, Object oldValue,
            Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPreWrite(writeVetoables,
                    this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, Object oldValue,
            Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(
                    writeListeners, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, int index,
            Object oldValue, Object newValue) {
        TopiaContextImplementor contextImplementor = (TopiaContextImplementor) getTopiaContext();
        if (contextImplementor != null) {
            contextImplementor.getFiresSupport().fireOnPostWrite(
                    writeListeners, this, propertyName, index, oldValue,
                    newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        writeListeners.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        writeListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable) {
        writeVetoables.addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoable) {
        writeVetoables.addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener) {
        writeListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        writeListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable) {
        writeVetoables.removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vetoable) {
        writeVetoables.removeVetoableChangeListener(vetoable);
    }

    @Override
    public void addPropertyListener(String propertyName,
            PropertyChangeListener listener) {
        readListeners.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener listener) {
        readListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableListener(String propertyName,
            VetoableChangeListener vetoable) {
        readVetoables.addVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void addVetoableListener(VetoableChangeListener vetoable) {
        readVetoables.addVetoableChangeListener(vetoable);
    }

    @Override
    public void removePropertyListener(String propertyName,
            PropertyChangeListener listener) {
        readListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener listener) {
        readListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableListener(String propertyName,
            VetoableChangeListener vetoable) {
        readVetoables.removeVetoableChangeListener(propertyName, vetoable);
    }

    @Override
    public void removeVetoableListener(VetoableChangeListener vetoable) {
        readVetoables.removeVetoableChangeListener(vetoable);
    }

} //TopiaEntityAbstract
