package org.nuiton.topia.it.mapping.test17;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class BB17Abstract extends AbstractTopiaEntity implements BB17 {

    /**
     * Nom de l'attribut en BD : cc
     */
    protected int bb;

    /**
     * Nom de l'attribut en BD : bb1
     */
    protected int bb1;

    /**
     * Nom de l'attribut en BD : b17
     */
    protected Collection<B17> b17;

    private static final long serialVersionUID = 7293914085985759331L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_BB, int.class, bb);
        visitor.visit(this, PROPERTY_BB1, int.class, bb1);
        visitor.visit(this, PROPERTY_B17, Collection.class, B17.class, b17);
    }

    @Override
    public void setBb(int bb) {
        this.bb = bb;
    }

    @Override
    public int getBb() {
        int result = this.bb;
        return result;
    }

    @Override
    public void setBb1(int bb1) {
        this.bb1 = bb1;
    }

    @Override
    public int getBb1() {
        int result = this.bb1;
        return result;
    }

    @Override
    public void addB17(B17 b17) {
        if (this.b17 == null) {
            this.b17 = new LinkedList<B17>();
        }
        this.b17.add(b17);
    }

    @Override
    public void addAllB17(Iterable<B17> b17) {
        if (b17 == null) {
            return;
        }
        for (B17 item : b17) {
            addB17(item);
        }
    }

    @Override
    public void setB17(Collection<B17> b17) {
        this.b17 = b17;
    }

    @Override
    public void removeB17(B17 b17) {
        if (this.b17 == null || !this.b17.remove(b17)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearB17() {
        if (this.b17 == null) {
            return;
        }
        this.b17.clear();
    }

    @Override
    public Collection<B17> getB17() {
        return b17;
    }

    @Override
    public B17 getB17ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b17, topiaId);
    }

    @Override
    public Collection<String> getB17TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test17.B17> tmp = getB17();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB17() {
        if (b17 == null) {
            return 0;
        }
        return b17.size();
    }

    @Override
    public boolean isB17Empty() {
        int size = sizeB17();
        return size == 0;
    }

    @Override
    public boolean isB17NotEmpty() {
        boolean empty = isB17Empty();
        return ! empty;
    }

    @Override
    public boolean containsB17(B17 b17) {
        boolean contains = this.b17 !=null && this.b17.contains(b17);
        return contains;
    }

} //BB17Abstract
