package org.nuiton.topia.it.mapping.test1;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A1Abstract extends AbstractTopiaEntity implements A1 {

    /**
     * Nom de l'attribut en BD : b1
     */
    protected Collection<B1> b1;

    private static final long serialVersionUID = 7017510039702365284L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B1, Collection.class, B1.class, b1);
    }

    @Override
    public void addB1(B1 b1) {
        if (this.b1 == null) {
            this.b1 = new LinkedList<B1>();
        }
        this.b1.add(b1);
    }

    @Override
    public void addAllB1(Iterable<B1> b1) {
        if (b1 == null) {
            return;
        }
        for (B1 item : b1) {
            addB1(item);
        }
    }

    @Override
    public void setB1(Collection<B1> b1) {
        this.b1 = b1;
    }

    @Override
    public void removeB1(B1 b1) {
        if (this.b1 == null || !this.b1.remove(b1)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearB1() {
        if (this.b1 == null) {
            return;
        }
        this.b1.clear();
    }

    @Override
    public Collection<B1> getB1() {
        return b1;
    }

    @Override
    public B1 getB1ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b1, topiaId);
    }

    @Override
    public Collection<String> getB1TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test1.B1> tmp = getB1();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB1() {
        if (b1 == null) {
            return 0;
        }
        return b1.size();
    }

    @Override
    public boolean isB1Empty() {
        int size = sizeB1();
        return size == 0;
    }

    @Override
    public boolean isB1NotEmpty() {
        boolean empty = isB1Empty();
        return ! empty;
    }

    @Override
    public boolean containsB1(B1 b1) {
        boolean contains = this.b1 !=null && this.b1.contains(b1);
        return contains;
    }

} //A1Abstract
