package org.nuiton.topia.it;

/*
 * #%L
 * ToPIA :: IT
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaConfigurationConstants;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;

/**
 * Created on 7/6/14.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class TopiaSchemaHelper {

    private static final Log log = LogFactory.getLog(TopiaSchemaHelper.class);

    protected static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            } catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to close: " + eee.getMessage() , eee);
                }
            }
        }
    }

    protected static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            } catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to close: " + eee.getMessage() , eee);
                }
            }
        }
    }

    /**
     * Create the physical schema.
     *
     * @param config     sql connection configuration
     * @param schemaName name of schema to create
     * @throws Exception if could not create schema
     * @since 3.0
     */
    public static void createSchema(Map<String, String> config, String schemaName) throws Exception {
        Connection connection = null;
        CallableStatement callableStatement = null;
        try {
            //DriverManager.registerDriver(new Driver());
            connection = DriverManager.getConnection(
                    config.get(TopiaConfigurationConstants.CONFIG_URL),
                    config.get(TopiaConfigurationConstants.CONFIG_USER),
                    config.get(TopiaConfigurationConstants.CONFIG_PASS));
            callableStatement = connection.prepareCall("create schema " + schemaName);
            callableStatement.execute();
        } finally {
            closeQuietly(callableStatement);
            closeQuietly(connection);
        }
    }

    /**
     * The mapping database use two extra schema (A and B) see test17.
     *
     * @param config database connection configuration
     * @throws Exception if could not create schemas on database
     */
    public static void createMappingDataBaseSchemas(Map<String, String> config) throws Exception {

        createSchema(config, "A");
        createSchema(config, "B");

    }

}
