/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.it;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.it.legacy.TopiaTestEntityEnum;
import org.nuiton.topia.junit.ConfigurationHelper;

public class TopiaConfigurationHelper
extends ConfigurationHelper {
    private static final Log log = LogFactory.getLog(TopiaConfigurationHelper.class);
    public static final String DEFAULT_CONFIGURATION_LOCATION = "/TopiaContextImpl.properties";

    public static Properties initTopiaContextConfiguration(File testDirectory, String dbPropertiesPath, String dbname) throws IOException {
        Properties configuration = TopiaConfigurationHelper.loadHibernateConfiguration(dbPropertiesPath);
        String dbPath = TopiaConfigurationHelper.getDbName(testDirectory, dbname);
        if (log.isInfoEnabled()) {
            log.info((Object)("dbPath = " + dbPath));
        }
        configuration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath);
        return configuration;
    }

    public static Properties loadHibernateConfiguration(String dbPropertiesPath) throws IOException {
        InputStream stream = TopiaConfigurationHelper.class.getResourceAsStream(dbPropertiesPath);
        Properties configuration = new Properties();
        configuration.load(stream);
        configuration.setProperty("topia.persistence.classes", TopiaTestEntityEnum.getImplementationClassesAsString());
        return configuration;
    }

    public static String getDbName(File testDirectory, String dbname) {
        return new File(testDirectory, dbname + '_' + System.nanoTime()).getAbsolutePath();
    }

    public static Properties initTopiaContextConfiguration(File testDirectory, String dbname) throws IOException {
        return TopiaConfigurationHelper.initTopiaContextConfiguration(testDirectory, DEFAULT_CONFIGURATION_LOCATION, dbname);
    }
}

