/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;

public class JarResourcesGenerator
extends AbstractGenerator {
    private final Collection jarResources;

    public JarResourcesGenerator(MavenProject mavenProject, File resourceLoaderPath, String defaultTemplateResourceName, File outputFile, String templateFile, Collection jarResources, String mainClass, String webstartJarURL) {
        super(mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, templateFile, mainClass, webstartJarURL);
        this.jarResources = jarResources;
    }

    protected String getDependenciesText() {
        String jarResourcesText = "";
        if (this.jarResources.size() != 0) {
            StringBuffer buffer = new StringBuffer(100 * this.jarResources.size());
            buffer.append("\n");
            for (JarResource jarResource : this.jarResources) {
                if (!jarResource.isIncludeInJnlp()) continue;
                buffer.append("<jar href=\"").append(jarResource.getHrefValue()).append("\"");
                if (jarResource.isOutputJarVersion()) {
                    buffer.append(" version=\"").append(jarResource.getVersion()).append("\"");
                }
                if (jarResource.getMainClass() != null) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            jarResourcesText = buffer.toString();
        }
        return jarResourcesText;
    }
}

