/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.jar.JarSignVerifyMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.webstart.AbstractBaseJnlpMojo;
import org.codehaus.mojo.webstart.JnlpConfig;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.generator.ExtensionGenerator;
import org.codehaus.mojo.webstart.generator.Generator;
import org.codehaus.mojo.webstart.generator.GeneratorExtraConfig;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public abstract class AbstractJnlpMojo
extends AbstractBaseJnlpMojo {
    private static final String DEFAULT_TEMPLATE_LOCATION = "src/main/jnlp/template.vm";
    private ZipArchiver zipArchiver;
    private JnlpConfig jnlp;
    private Dependencies dependencies;
    private List jnlpExtensions;
    private boolean skip;
    private String keystore;
    private File basedir;
    private MavenProjectHelper projectHelper;
    private Settings settings;
    private PluginManager pluginManager;
    private List packagedJnlpArtifacts = new ArrayList();
    private Map extensionsJnlpArtifacts = new HashMap();
    private Artifact artifactWithMainClass;
    private boolean outputJarVersions;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip goal execution as required.");
            return;
        }
        boolean withExtensions = this.hasJnlpExtensions();
        if (withExtensions) {
            this.prepareExtensions();
            this.findDefaultJnlpExtensionTemplateURL();
        }
        this.checkInput();
        this.findDefaultJnlpTemplateURL();
        this.getLog().debug((CharSequence)("using work directory " + this.getWorkDirectory()));
        this.getLog().debug((CharSequence)("using library directory " + this.getLibDirectory()));
        this.makeWorkingDirIfNecessary();
        try {
            this.copyResources(this.getResourcesDirectory(), this.getLibDirectory());
            this.artifactWithMainClass = null;
            this.processDependencies();
            if (withExtensions) {
                this.processExtensionsDependencies();
            }
            if (this.artifactWithMainClass == null) {
                throw new MojoExecutionException("didn't find artifact with main class: " + this.jnlp.getMainClass() + ". Did you specify it? ");
            }
            if ((this.isPack200() || this.getSign() != null) && this.getLog().isDebugEnabled()) {
                this.logCollection("Some dependencies may be skipped. Here's the list of the artifacts that should be signed/packed: ", this.getModifiedJnlpArtifacts());
            }
            this.signOrRenameJars();
            this.packJars();
            this.generateJnlpFile(this.getWorkDirectory());
            if (withExtensions) {
                this.generateJnlpExtensionsFile(this.getWorkDirectory());
            }
            if (this.isMakeArchive()) {
                File toFile = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + ".zip");
                if (toFile.exists()) {
                    this.getLog().debug((CharSequence)("deleting file " + toFile));
                    toFile.delete();
                }
                this.zipArchiver.addDirectory(this.getWorkDirectory());
                this.zipArchiver.setDestFile(toFile);
                this.getLog().debug((CharSequence)"about to call createArchive");
                this.zipArchiver.createArchive();
                if (this.isAttachArchive()) {
                    this.projectHelper.attachArtifact(this.getProject(), "zip", toFile);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure to run the plugin: ", e);
        }
    }

    public List getJnlpExtensions() {
        return this.jnlpExtensions;
    }

    public boolean hasJnlpExtensions() {
        return this.jnlpExtensions != null && !this.jnlpExtensions.isEmpty();
    }

    void checkDependencies() throws MojoExecutionException {
        if (this.dependencies == null) {
            return;
        }
        boolean failed = false;
        Set artifacts = this.getProject().getArtifacts();
        this.getLog().debug((CharSequence)("artifacts: " + artifacts.size()));
        if (this.dependencies.getIncludes() != null && !this.dependencies.getIncludes().isEmpty()) {
            boolean bl = failed = this.checkDependencies(this.dependencies.getIncludes(), artifacts) || failed;
        }
        if (this.dependencies.getExcludes() != null && !this.dependencies.getExcludes().isEmpty()) {
            boolean bl = failed = this.checkDependencies(this.dependencies.getExcludes(), artifacts) || failed;
        }
        if (failed) {
            throw new MojoExecutionException("At least one specified dependency is incorrect. Review your project configuration.");
        }
    }

    private boolean checkDependencies(List patterns, Collection artifacts) {
        if (this.dependencies == null) {
            return false;
        }
        boolean failed = false;
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            failed = this.ensurePatternMatchesAtLeastOneArtifact(it.next().toString(), artifacts) || failed;
        }
        return failed;
    }

    private boolean ensurePatternMatchesAtLeastOneArtifact(String pattern, Collection artifacts) {
        ArrayList<String> onePatternList = new ArrayList<String>();
        onePatternList.add(pattern);
        IncludesArtifactFilter filter = new IncludesArtifactFilter(onePatternList);
        boolean noMatch = true;
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("checking pattern: " + pattern + " against " + artifact));
            if (!filter.include(artifact)) continue;
            noMatch = false;
            break;
        }
        if (noMatch) {
            this.getLog().error((CharSequence)("pattern: " + pattern + " doesn't match any artifact."));
        }
        return noMatch;
    }

    private void processDependencies() throws IOException {
        this.processDependency(this.getProject().getArtifact());
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.dependencies != null && this.dependencies.getIncludes() != null && !this.dependencies.getIncludes().isEmpty()) {
            filter.add((ArtifactFilter)new IncludesArtifactFilter(this.dependencies.getIncludes()));
        }
        if (this.dependencies != null && this.dependencies.getExcludes() != null && !this.dependencies.getExcludes().isEmpty()) {
            filter.add((ArtifactFilter)new ExcludesArtifactFilter(this.dependencies.getExcludes()));
        }
        Set artifacts = this.isExcludeTransitive() ? this.getProject().getDependencyArtifacts() : this.getProject().getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            this.processDependency(artifact);
        }
    }

    private void processDependency(Artifact artifact) throws IOException {
        if (!("system".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()))) {
            String type = artifact.getType();
            if ("jar".equals(type) || "ejb-client".equals(type)) {
                File toCopy = artifact.getFile();
                if (toCopy == null) {
                    this.getLog().error((CharSequence)("artifact with no file: " + artifact));
                    this.getLog().error((CharSequence)("artifact download url: " + artifact.getDownloadUrl()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getRepository()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getVersion()));
                    throw new IllegalStateException("artifact " + artifact + " has no matching file, why? Check the logs...");
                }
                boolean copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(toCopy, this.getLibDirectory());
                if (copied) {
                    String name = toCopy.getName();
                    this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
                }
                this.packagedJnlpArtifacts.add(artifact);
                if (this.jnlp != null && this.artifactContainsClass(artifact, this.jnlp.getMainClass())) {
                    if (this.artifactWithMainClass == null) {
                        this.artifactWithMainClass = artifact;
                        this.getLog().debug((CharSequence)("Found main jar. Artifact " + this.artifactWithMainClass + " contains the main class: " + this.jnlp.getMainClass()));
                    } else {
                        this.getLog().warn((CharSequence)("artifact " + artifact + " also contains the main class: " + this.jnlp.getMainClass() + ". IGNORED."));
                    }
                }
            } else {
                this.verboseLog("Skipping artifact of type " + type + " for " + this.getLibDirectory().getName());
            }
        } else {
            this.verboseLog("Skipping artifact of scope " + artifact.getScope() + " for " + this.getLibDirectory().getName());
        }
    }

    void generateJnlpFile(File outputDirectory) throws MojoExecutionException {
        File templateFile;
        if (this.jnlp.getOutputFile() == null || this.jnlp.getOutputFile().length() == 0) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified. Using default output file name: launch.jnlp.");
            this.jnlp.setOutputFile("launch.jnlp");
        }
        File jnlpOutputFile = new File(outputDirectory, this.jnlp.getOutputFile());
        File templateDirectory = this.getProject().getBasedir();
        if (this.jnlp.getInputTemplateResourcePath() != null && this.jnlp.getInputTemplateResourcePath().length() > 0) {
            templateDirectory = new File(this.jnlp.getInputTemplateResourcePath());
        }
        if (this.jnlp.getInputTemplate() == null || this.jnlp.getInputTemplate().length() == 0) {
            this.getLog().debug((CharSequence)"Jnlp template file name not specified. Checking if default output file name exists: src/main/jnlp/template.vm");
            templateFile = new File(templateDirectory, DEFAULT_TEMPLATE_LOCATION);
            if (templateFile.isFile()) {
                this.jnlp.setInputTemplate(DEFAULT_TEMPLATE_LOCATION);
            } else {
                this.getLog().debug((CharSequence)"Jnlp template file not found in default location. Using inbuilt one.");
            }
        } else {
            templateFile = new File(templateDirectory, this.jnlp.getInputTemplate());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP template does not exist: [" + templateFile + "]");
            }
        }
        String templateFileName = this.jnlp.getInputTemplate();
        Generator jnlpGenerator = new Generator(this.getProject(), this, "default-jnlp-template.vm", templateDirectory, jnlpOutputFile, templateFileName, this.getJnlp().getMainClass(), this.getWebstartJarURLForVelocity());
        jnlpGenerator.setExtraConfig(this.getGeneratorExtraConfig());
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.toString());
            throw new MojoExecutionException("Could not generate the JNLP deployment descriptor", e);
        }
    }

    private void logCollection(String prefix, Collection collection) {
        this.getLog().debug((CharSequence)(prefix + " " + collection));
        if (collection == null) {
            return;
        }
        Iterator it3 = collection.iterator();
        while (it3.hasNext()) {
            this.getLog().debug((CharSequence)(prefix + it3.next()));
        }
    }

    private GeneratorExtraConfig getGeneratorExtraConfig() {
        return new GeneratorExtraConfig(){

            public String getJnlpSpec() {
                if (AbstractJnlpMojo.this.jnlp.getSpec() != null) {
                    return AbstractJnlpMojo.this.jnlp.getSpec();
                }
                return "1.0+";
            }

            public String getOfflineAllowed() {
                if (AbstractJnlpMojo.this.jnlp.getOfflineAllowed() != null) {
                    return AbstractJnlpMojo.this.jnlp.getOfflineAllowed();
                }
                return "false";
            }

            public String getAllPermissions() {
                if (AbstractJnlpMojo.this.jnlp.getAllPermissions() != null) {
                    return AbstractJnlpMojo.this.jnlp.getAllPermissions();
                }
                return "true";
            }

            public String getJ2seVersion() {
                if (AbstractJnlpMojo.this.jnlp.getJ2seVersion() != null) {
                    return AbstractJnlpMojo.this.jnlp.getJ2seVersion();
                }
                return "1.5+";
            }

            public String getJnlpCodeBase() {
                return AbstractJnlpMojo.this.getCodebase();
            }
        };
    }

    private void checkInput() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("a fact " + this.getArtifactFactory()));
        this.getLog().debug((CharSequence)("a resol " + this.getArtifactResolver()));
        this.getLog().debug((CharSequence)("basedir " + this.basedir));
        this.getLog().debug((CharSequence)("gzip " + this.isGzip()));
        this.getLog().debug((CharSequence)("pack200 " + this.isPack200()));
        this.getLog().debug((CharSequence)("project " + this.getProject()));
        this.getLog().debug((CharSequence)("zipArchiver " + this.zipArchiver));
        this.getLog().debug((CharSequence)("verifyjar " + this.isVerifyjar()));
        this.getLog().debug((CharSequence)("verbose " + this.isVerbose()));
        this.checkPack200();
        this.checkDependencies();
        if (this.jnlp != null && this.jnlp.getResources() != null) {
            throw new MojoExecutionException("The <jnlp><resources> configuration element is obsolete. Use <resourcesDirectory> instead.");
        }
    }

    public JnlpConfig getJnlp() {
        return this.jnlp;
    }

    public List getPackagedJnlpArtifacts() {
        return this.packagedJnlpArtifacts;
    }

    public Map getExtensionsJnlpArtifacts() {
        return this.extensionsJnlpArtifacts;
    }

    Dependencies getDependencies() {
        return this.dependencies;
    }

    public boolean isArtifactWithMainClass(Artifact artifact) {
        boolean b = this.artifactWithMainClass.equals(artifact);
        this.getLog().debug((CharSequence)("compare " + this.artifactWithMainClass + " with " + artifact + ": " + b));
        return b;
    }

    private void verboseLog(String msg) {
        this.infoOrDebug(this.isVerbose() || this.getLog().isInfoEnabled(), msg);
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLog().info((CharSequence)msg);
        } else {
            this.getLog().debug((CharSequence)msg);
        }
    }

    public boolean isOutputJarVersions() {
        return this.outputJarVersions;
    }

    public void setOutputJarVersions(boolean outputJarVersions) {
        this.outputJarVersions = outputJarVersions;
    }

    void checkExtension(JnlpExtension extension) throws MojoExecutionException {
        if (extension.getName() == null || extension.getName().trim().isEmpty()) {
            throw new MojoExecutionException("JnlpExtension name is mandatory. Review your project configuration.");
        }
        if (extension.getVendor() == null || extension.getVendor().trim().isEmpty()) {
            throw new MojoExecutionException("JnlpExtension vendor is mandatory. Review your project configuration.");
        }
        if (extension.getTitle() == null || extension.getTitle().trim().isEmpty()) {
            throw new MojoExecutionException("JnlpExtension name is title. Review your project configuration.");
        }
        if (extension.getIncludes() == null || extension.getIncludes().isEmpty()) {
            throw new MojoExecutionException("JnlpExtension need at least one include artifact. Review your project configuration.");
        }
    }

    protected void prepareExtensions() throws MojoExecutionException {
        ArrayList<String> includes = new ArrayList<String>();
        for (JnlpExtension extension : this.jnlpExtensions) {
            this.checkExtension(extension);
            Iterator itrInclude = extension.getIncludes().iterator();
            while (itrInclude.hasNext()) {
                includes.add(((String)itrInclude.next()).trim());
            }
            if (extension.getOutputFile() != null && extension.getOutputFile().length() != 0) continue;
            String name = extension.getName() + ".jnlp";
            this.verboseLog("Jnlp extension output file name not specified. Using default output file name: " + name + ".");
            extension.setOutputFile(name);
        }
        if (this.dependencies == null) {
            this.dependencies = new Dependencies();
        }
        if (this.dependencies.getExcludes() == null) {
            this.dependencies.setExcludes(new ArrayList());
        }
        this.dependencies.getExcludes().addAll(includes);
    }

    private void processExtensionsDependencies() throws IOException {
        Set artifacts = this.isExcludeTransitive() ? this.getProject().getDependencyArtifacts() : this.getProject().getArtifacts();
        JarSignVerifyMojo verifyMojo = this.setupVerifyMojo();
        verifyMojo.setVerbose(this.isVerbose());
        for (JnlpExtension extension : this.jnlpExtensions) {
            IncludesArtifactFilter filter = new IncludesArtifactFilter(extension.getIncludes());
            for (Artifact artifact : artifacts) {
                if (!filter.include(artifact)) continue;
                this.processExtensionDependency(extension, artifact, verifyMojo);
            }
        }
    }

    private void processExtensionDependency(JnlpExtension extension, Artifact artifact, JarSignVerifyMojo verifyMojo) throws IOException {
        if (!("system".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()))) {
            String type = artifact.getType();
            if ("jar".equals(type) || "ejb-client".equals(type)) {
                File toCopy = artifact.getFile();
                if (toCopy == null) {
                    this.getLog().error((CharSequence)("artifact with no file: " + artifact));
                    this.getLog().error((CharSequence)("artifact download url: " + artifact.getDownloadUrl()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getRepository()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getVersion()));
                    throw new IllegalStateException("artifact " + artifact + " has no matching file, why? Check the logs...");
                }
                verifyMojo.setJarPath(toCopy);
                try {
                    verifyMojo.execute();
                }
                catch (MojoExecutionException e) {
                    throw new IllegalStateException("artifact " + artifact + " must be signed as part of an extension..");
                }
                boolean copied = this.copyFileToDirectoryIfNecessary(toCopy, this.getLibDirectory());
                if (copied) {
                    this.verboseLog("copy extension artifact " + toCopy);
                } else {
                    this.verboseLog("already up to date artifact " + toCopy);
                }
                ArrayList<Artifact> deps = (ArrayList<Artifact>)this.extensionsJnlpArtifacts.get(extension);
                if (deps == null) {
                    deps = new ArrayList<Artifact>();
                    this.extensionsJnlpArtifacts.put(extension, deps);
                }
                deps.add(artifact);
            } else {
                this.verboseLog("Skipping artifact of type " + type + " for " + this.getLibDirectory().getName());
            }
        } else {
            this.verboseLog("Skipping artifact of scope " + artifact.getScope() + " for " + this.getLibDirectory().getName());
        }
    }

    void generateJnlpExtensionsFile(File outputDirectory) throws MojoExecutionException {
        Iterator itr = this.jnlpExtensions.iterator();
        while (itr.hasNext()) {
            this.generateJnlpExtensionFile(outputDirectory, (JnlpExtension)itr.next());
        }
    }

    void generateJnlpExtensionFile(File outputDirectory, JnlpExtension extension) throws MojoExecutionException {
        File templateFile;
        File jnlpOutputFile = new File(outputDirectory, extension.getOutputFile());
        File templateDirectory = this.getProject().getBasedir();
        if (extension.getInputTemplateResourcePath() != null && extension.getInputTemplateResourcePath().length() > 0) {
            templateDirectory = new File(extension.getInputTemplateResourcePath());
        }
        if (extension.getInputTemplate() == null || extension.getInputTemplate().length() == 0) {
            this.getLog().debug((CharSequence)"Jnlp extension template file name not specified. Checking if default output file name exists: src/main/jnlp/template.vm");
            templateFile = new File(templateDirectory, DEFAULT_TEMPLATE_LOCATION);
            if (templateFile.isFile()) {
                extension.setInputTemplate(DEFAULT_TEMPLATE_LOCATION);
            } else {
                this.getLog().debug((CharSequence)"Jnlp extension template file not found in default location. Using inbuilt one.");
            }
        } else {
            templateFile = new File(templateDirectory, extension.getInputTemplate());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP extension template does not exist: [" + templateFile + "]");
            }
        }
        String templateFileName = extension.getInputTemplate();
        ExtensionGenerator jnlpGenerator = new ExtensionGenerator(this.getProject(), this, extension, "default-jnlp-extension-template.vm", templateDirectory, jnlpOutputFile, templateFileName, this.getJnlp().getMainClass(), this.getWebstartJarURLForVelocity());
        jnlpGenerator.setExtraConfig(this.getExtensionGeneratorExtraConfig(extension));
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.toString());
            throw new MojoExecutionException("Could not generate the JNLP deployment descriptor", e);
        }
    }

    private GeneratorExtraConfig getExtensionGeneratorExtraConfig(final JnlpExtension extension) {
        return new GeneratorExtraConfig(){

            public String getJnlpSpec() {
                if (extension.getSpec() != null) {
                    return extension.getSpec();
                }
                return "1.0+";
            }

            public String getOfflineAllowed() {
                if (extension.getOfflineAllowed() != null) {
                    return extension.getOfflineAllowed();
                }
                return "false";
            }

            public String getAllPermissions() {
                if (extension.getAllPermissions() != null) {
                    return extension.getAllPermissions();
                }
                return "true";
            }

            public String getJ2seVersion() {
                if (extension.getJ2seVersion() != null) {
                    return extension.getJ2seVersion();
                }
                return "1.5+";
            }

            public String getJnlpCodeBase() {
                return AbstractJnlpMojo.this.getCodebase();
            }
        };
    }

    public static class Dependencies {
        private boolean outputJarVersions;
        private List includes;
        private List excludes;

        public boolean getOutputJarVersions() {
            return this.outputJarVersions;
        }

        public List getIncludes() {
            return this.includes;
        }

        public void setIncludes(List includes) {
            this.includes = includes;
        }

        public List getExcludes() {
            return this.excludes;
        }

        public void setExcludes(List excludes) {
            this.excludes = excludes;
        }
    }
}

