/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RtfGenerator {
    private List fontList = new ArrayList(1);
    private List colorList = new ArrayList(1);
    private StringBuffer document = new StringBuffer();
    private boolean lastWasControlWord;
    private int lastFontIndex;
    private int lastFGIndex;
    private boolean lastBold;
    private boolean lastItalic;
    private int lastFontSize;
    private String monospacedFontName;
    private int screenRes;
    private static final int DEFAULT_FONT_SIZE = 12;

    public RtfGenerator() {
        this.reset();
    }

    public void appendNewline() {
        this.document.append("\\par");
        this.document.append('\n');
        this.lastWasControlWord = false;
    }

    public void appendToDoc(String string, Font font, Color color, Color color2) {
        this.appendToDoc(string, font, color, color2, false);
    }

    public void appendToDocNoFG(String string, Font font, Color color, boolean bl) {
        this.appendToDoc(string, font, null, color, bl, false);
    }

    public void appendToDoc(String string, Font font, Color color, Color color2, boolean bl) {
        this.appendToDoc(string, font, color, color2, bl, true);
    }

    public void appendToDoc(String string, Font font, Color color, Color color2, boolean bl, boolean bl2) {
        if (string != null) {
            int n;
            int n2;
            int n3 = n2 = font == null ? 0 : RtfGenerator.getFontIndex(this.fontList, font) + 1;
            if (n2 != this.lastFontIndex) {
                this.document.append("\\f").append(n2);
                this.lastFontIndex = n2;
                this.lastWasControlWord = true;
            }
            if (font != null) {
                n = this.fixFontSize(font.getSize2D());
                if (n != this.lastFontSize) {
                    this.document.append("\\fs").append(n);
                    this.lastFontSize = n;
                    this.lastWasControlWord = true;
                }
                if (font.isBold() != this.lastBold) {
                    this.document.append(this.lastBold ? "\\b0" : "\\b");
                    this.lastBold = !this.lastBold;
                    this.lastWasControlWord = true;
                }
                if (font.isItalic() != this.lastItalic) {
                    this.document.append(this.lastItalic ? "\\i0" : "\\i");
                    this.lastItalic = !this.lastItalic;
                    this.lastWasControlWord = true;
                }
            } else {
                if (this.lastFontSize != 12) {
                    this.document.append("\\fs").append(12);
                    this.lastFontSize = 12;
                    this.lastWasControlWord = true;
                }
                if (this.lastBold) {
                    this.document.append("\\b0");
                    this.lastBold = false;
                    this.lastWasControlWord = true;
                }
                if (this.lastItalic) {
                    this.document.append("\\i0");
                    this.lastItalic = false;
                    this.lastWasControlWord = true;
                }
            }
            if (bl) {
                this.document.append("\\ul");
                this.lastWasControlWord = true;
            }
            if (bl2) {
                n = 0;
                if (color != null) {
                    n = RtfGenerator.getIndex(this.colorList, color) + 1;
                }
                if (n != this.lastFGIndex) {
                    this.document.append("\\cf").append(n);
                    this.lastFGIndex = n;
                    this.lastWasControlWord = true;
                }
            }
            if (color2 != null) {
                n = RtfGenerator.getIndex(this.colorList, color2);
                this.document.append("\\highlight").append(n + 1);
                this.lastWasControlWord = true;
            }
            if (this.lastWasControlWord) {
                this.document.append(' ');
                this.lastWasControlWord = false;
            }
            this.escapeAndAdd(this.document, string);
            if (color2 != null) {
                this.document.append("\\highlight0");
                this.lastWasControlWord = true;
            }
            if (bl) {
                this.document.append("\\ul0");
                this.lastWasControlWord = true;
            }
        }
    }

    private final void escapeAndAdd(StringBuffer stringBuffer, String string) {
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\tab");
                    while (++i < n && string.charAt(i) == '\t') {
                        stringBuffer.append("\\tab");
                    }
                    stringBuffer.append(' ');
                    --i;
                    continue block4;
                }
                case '\\': 
                case '{': 
                case '}': {
                    stringBuffer.append('\\').append(c);
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    private int fixFontSize(float f) {
        if (this.screenRes != 72) {
            f = (int)Math.round((double)(f * (float)this.screenRes) / 72.0);
        }
        return (int)f;
    }

    private String getColorTableRtf() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\\colortbl ;");
        for (int i = 0; i < this.colorList.size(); ++i) {
            Color color = (Color)this.colorList.get(i);
            stringBuffer.append("\\red").append(color.getRed());
            stringBuffer.append("\\green").append(color.getGreen());
            stringBuffer.append("\\blue").append(color.getBlue());
            stringBuffer.append(';');
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static int getFontIndex(List list, Font font) {
        String string = font.getFamily();
        for (int i = 0; i < list.size(); ++i) {
            Font font2 = (Font)list.get(i);
            if (!font2.getFamily().equals(string)) continue;
            return i;
        }
        list.add(font);
        return list.size() - 1;
    }

    private String getFontTableRtf() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getMonospacedFontName();
        stringBuffer.append("{\\fonttbl{\\f0\\fnil\\fcharset0 " + string + ";}");
        for (int i = 0; i < this.fontList.size(); ++i) {
            Font font = (Font)this.fontList.get(i);
            String string2 = font.getFamily();
            if (string2.equals("Monospaced")) {
                string2 = string;
            }
            stringBuffer.append("{\\f").append(i + 1).append("\\fnil\\fcharset0 ");
            stringBuffer.append(string2).append(";}");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static int getIndex(List list, Object object) {
        int n = list.indexOf(object);
        if (n == -1) {
            list.add(object);
            n = list.size() - 1;
        }
        return n;
    }

    private String getMonospacedFontName() {
        if (this.monospacedFontName == null) {
            boolean bl;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Object[] objectArray = graphicsEnvironment.getAvailableFontFamilyNames();
            Arrays.sort(objectArray);
            boolean bl2 = bl = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
            if (!bl && Arrays.binarySearch(objectArray, "Monaco") >= 0) {
                this.monospacedFontName = "Monaco";
            } else if (Arrays.binarySearch(objectArray, "Courier New") >= 0) {
                this.monospacedFontName = "Courier New";
            } else if (Arrays.binarySearch(objectArray, "Courier") >= 0) {
                this.monospacedFontName = "Courier";
            } else if (Arrays.binarySearch(objectArray, "Nimbus Mono L") >= 0) {
                this.monospacedFontName = "Nimbus Mono L";
            } else if (Arrays.binarySearch(objectArray, "Lucida Sans Typewriter") >= 0) {
                this.monospacedFontName = "Lucida Sans Typewriter";
            } else if (Arrays.binarySearch(objectArray, "Bitstream Vera Sans Mono") >= 0) {
                this.monospacedFontName = "Bitstream Vera Sans Mono";
            }
            if (this.monospacedFontName == null) {
                this.monospacedFontName = "Terminal";
            }
        }
        return this.monospacedFontName;
    }

    public String getRtf() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\\rtf1\\ansi\\ansicpg1252");
        stringBuffer.append("\\deff0");
        stringBuffer.append("\\deflang1033");
        stringBuffer.append("\\viewkind4");
        stringBuffer.append("\\uc\\pard\\f0");
        stringBuffer.append("\\fs20");
        stringBuffer.append(this.getFontTableRtf()).append('\n');
        stringBuffer.append(this.getColorTableRtf()).append('\n');
        stringBuffer.append(this.document);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void reset() {
        this.fontList.clear();
        this.colorList.clear();
        this.document.setLength(0);
        this.lastWasControlWord = false;
        this.lastFontIndex = 0;
        this.lastFGIndex = 0;
        this.lastBold = false;
        this.lastItalic = false;
        this.lastFontSize = 12;
        this.screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

