/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.ChangeableColorHighlightPainter;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextArea;

public class RSyntaxTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    private RTextArea textArea;
    private List markedOccurrences = new ArrayList();
    private List parserHighlights = new ArrayList(0);
    private static final Color DEFAULT_PARSER_NOTICE_COLOR = Color.RED;

    Object addMarkedOccurrenceHighlight(int n, int n2, MarkOccurrencesHighlightPainter markOccurrencesHighlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        LayeredHighlightInfo layeredHighlightInfo = new LayeredHighlightInfo();
        layeredHighlightInfo.painter = markOccurrencesHighlightPainter;
        ((HighlightInfo)layeredHighlightInfo).p0 = document.createPosition(n);
        ((HighlightInfo)layeredHighlightInfo).p1 = document.createPosition(n2 - 1);
        this.markedOccurrences.add(layeredHighlightInfo);
        textUI.damageRange(this.textArea, n, n2);
        return layeredHighlightInfo;
    }

    Object addParserHighlight(ParserNotice parserNotice, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        int n = parserNotice.getOffset();
        int n2 = n + parserNotice.getLength();
        LayeredHighlightInfo layeredHighlightInfo = new LayeredHighlightInfo();
        layeredHighlightInfo.painter = highlightPainter;
        ((HighlightInfo)layeredHighlightInfo).p0 = document.createPosition(n);
        ((HighlightInfo)layeredHighlightInfo).p1 = document.createPosition(n2);
        ((HighlightInfo)layeredHighlightInfo).notice = parserNotice;
        this.parserHighlights.add(layeredHighlightInfo);
        textUI.damageRange(this.textArea, n, n2);
        return layeredHighlightInfo;
    }

    void clearParserHighlights() {
        for (int i = 0; i < this.parserHighlights.size(); ++i) {
            HighlightInfo highlightInfo;
            Object e = this.parserHighlights.get(i);
            if (e instanceof LayeredHighlightInfo) {
                highlightInfo = (LayeredHighlightInfo)e;
                if (((LayeredHighlightInfo)highlightInfo).width <= 0 || ((LayeredHighlightInfo)highlightInfo).height <= 0) continue;
                this.textArea.repaint(((LayeredHighlightInfo)highlightInfo).x, ((LayeredHighlightInfo)highlightInfo).y, ((LayeredHighlightInfo)highlightInfo).width, ((LayeredHighlightInfo)highlightInfo).height);
                continue;
            }
            highlightInfo = (HighlightInfo)e;
            TextUI textUI = this.textArea.getUI();
            textUI.damageRange(this.textArea, highlightInfo.getStartOffset(), highlightInfo.getEndOffset());
        }
        this.parserHighlights.clear();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textArea = null;
        this.markedOccurrences.clear();
        this.parserHighlights.clear();
    }

    public List getMarkedOccurrences() {
        ArrayList<DocumentRangeImpl> arrayList = new ArrayList<DocumentRangeImpl>(this.markedOccurrences.size());
        Iterator iterator = this.markedOccurrences.iterator();
        while (iterator.hasNext()) {
            HighlightInfo highlightInfo = (HighlightInfo)iterator.next();
            int n = highlightInfo.getStartOffset();
            int n2 = highlightInfo.getEndOffset() + 1;
            DocumentRangeImpl documentRangeImpl = new DocumentRangeImpl(n, n2);
            arrayList.add(documentRangeImpl);
        }
        return arrayList;
    }

    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        this.textArea = (RTextArea)jTextComponent;
    }

    public void paint(Graphics graphics) {
        this.paintList(graphics, this.markedOccurrences);
        super.paint(graphics);
        this.paintList(graphics, this.parserHighlights);
    }

    private void paintList(Graphics graphics, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = (HighlightInfo)list.get(i);
            if (highlightInfo instanceof LayeredHighlightInfo) continue;
            Rectangle rectangle = this.textArea.getBounds();
            Insets insets = this.textArea.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i < n) {
                highlightInfo = (HighlightInfo)this.markedOccurrences.get(i);
                if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                    Color color = highlightInfo.getColor();
                    Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                    if (color != null && highlightPainter instanceof ChangeableColorHighlightPainter) {
                        ((ChangeableColorHighlightPainter)highlightPainter).setColor(color);
                    }
                    highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.textArea);
                }
                ++i;
            }
        }
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        this.paintListLayered(graphics, n, n2, shape, jTextComponent, view, this.markedOccurrences);
        super.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        this.paintListLayered(graphics, n, n2, shape, jTextComponent, view, this.parserHighlights);
    }

    private void paintListLayered(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view, List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)e;
            int n3 = layeredHighlightInfo.getStartOffset();
            int n4 = layeredHighlightInfo.getEndOffset();
            if ((n >= n3 || n2 <= n3) && (n < n3 || n >= n4)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        }
    }

    private void removeListHighlight(List list, Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.textArea.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            TextUI textUI = this.textArea.getUI();
            textUI.damageRange(this.textArea, highlightInfo.getStartOffset(), highlightInfo.getEndOffset());
        }
        list.remove(object);
    }

    void removeMarkOccurrencesHighlight(Object object) {
        this.removeListHighlight(this.markedOccurrences, object);
    }

    void removeParserHighlight(Object object) {
        this.removeListHighlight(this.parserHighlights, object);
    }

    private static class LayeredHighlightInfo
    extends HighlightInfo {
        private int x;
        private int y;
        private int width;
        private int height;

        private LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            Rectangle rectangle;
            if (shape == null) {
                return;
            }
            Rectangle rectangle2 = rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            n = Math.max(n3, n);
            n2 = Math.min(n4, n2);
            if (this.getColor() != null && this.painter instanceof ChangeableColorHighlightPainter) {
                ((ChangeableColorHighlightPainter)this.painter).setColor(this.getColor());
            }
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(graphics, n, n2, shape, jTextComponent, view));
        }
    }

    private static class HighlightInfo
    implements Highlighter.Highlight {
        private Position p0;
        private Position p1;
        protected Highlighter.HighlightPainter painter;
        private ParserNotice notice;

        private HighlightInfo() {
        }

        public Color getColor() {
            Color color = null;
            if (this.notice != null && (color = this.notice.getColor()) == null) {
                color = DEFAULT_PARSER_NOTICE_COLOR;
            }
            return color;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    private static class DocumentRangeImpl
    implements DocumentRange {
        private int startOffs;
        private int endOffs;

        public DocumentRangeImpl(int n, int n2) {
            this.startOffs = n;
            this.endOffs = n2;
        }

        public int getEndOffset() {
            return this.endOffs;
        }

        public int getStartOffset() {
            return this.startOffs;
        }
    }
}

