/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.DefaultFilter;
import org.nuiton.processor.filters.Filter;

public class ProcessorUtil {
    private static final Log log = LogFactory.getLog(ProcessorUtil.class);
    public static final String DEFAULT_ENCODING = System.getProperty("file.encoding");

    public static Processor newProcessor(String filters, String separator) throws Exception {
        Filter[] result = ProcessorUtil.getFilters(filters, separator);
        Processor processor = new Processor(result);
        return processor;
    }

    public static Filter[] getFilters(String filters, String separator) throws Exception {
        String[] filterList = filters.split(separator);
        Filter[] result = new Filter[filterList.length];
        for (int i = 0; i < filterList.length; ++i) {
            try {
                result[i] = (Filter)Class.forName(filterList[i].trim()).newInstance();
                continue;
            }
            catch (Exception eee) {
                throw new IllegalArgumentException("Error during looking for '" + filterList[i].trim() + "' class", eee);
            }
        }
        return result;
    }

    public static void doProcess(Processor processor, String in, String out, String encoding) throws IOException {
        ProcessorUtil.doProcess(processor, new File(in), new File(out), encoding);
    }

    @Deprecated
    public static void doProcess(Processor processor, String in, String out) throws IOException {
        ProcessorUtil.doProcess(processor, new File(in), new File(out), DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcess(Processor processor, File in, File out, String encoding) throws IOException {
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(in), encoding);
        try {
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(out), encoding);
            try {
                processor.process(input, output);
            }
            catch (IOException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error while processing file " + in + " to " + out + " with processor " + processor), (Throwable)eee);
                }
                throw eee;
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcess(Processor processor, InputStream in, OutputStream out, String encoding) throws IOException {
        InputStreamReader input = new InputStreamReader(in, encoding);
        try {
            OutputStreamWriter output = new OutputStreamWriter(out, encoding);
            try {
                processor.process(input, output);
            }
            catch (IOException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error while processing file " + in + " to " + out + " with processor " + processor), (Throwable)eee);
                }
                throw eee;
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    public static void doProcess(Processor processor, InputStreamReader in, OutputStreamWriter out) throws IOException {
        try {
            processor.process(in, out);
        }
        catch (IOException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error while processing file " + in + " to " + out + " with processor " + processor), (Throwable)eee);
            }
            throw eee;
        }
    }

    @Deprecated
    public static void doProcess(Processor processor, File in, File out) throws IOException {
        ProcessorUtil.doProcess(processor, in, out, DEFAULT_ENCODING);
    }

    public static class FragmentRemover
    extends DefaultFilter {
        private static final Log log = LogFactory.getLog(FragmentRemover.class);
        protected String header;
        protected String footer;
        protected boolean verbose;

        public FragmentRemover(String header, String footer) {
            this.header = header;
            this.footer = footer;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        protected String performInFilter(String ch) {
            if (this.verbose || log.isInfoEnabled()) {
                log.info((Object)("Will remove " + ch));
            }
            return "";
        }

        protected String performOutFilter(String ch) {
            return ch;
        }

        protected String getHeader() {
            return this.header;
        }

        protected String getFooter() {
            return this.footer;
        }
    }

    public static class FragmentExtractor
    extends DefaultFilter {
        protected static final Log log = LogFactory.getLog(FragmentExtractor.class);
        protected String header;
        protected String footer;
        protected boolean verbose;

        public FragmentExtractor(String header, String footer) {
            this.header = header;
            this.footer = footer;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        protected String performInFilter(String ch) {
            if (this.verbose || log.isInfoEnabled()) {
                log.info((Object)("Detected key " + ch));
            }
            return ch + "\n";
        }

        protected String performOutFilter(String ch) {
            return "";
        }

        protected String getHeader() {
            return this.header;
        }

        protected String getFooter() {
            return this.footer;
        }
    }
}

