/* *##% Graphical Widget
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * EditorInterface.java
 *
 * Created: 6 août 2006 12:54:19
 *
 * @author poussin
 * @version $Revision: 184 $
 *
 * Last update: $Date: 2009-05-16 06:01:36 +0200 (sam., 16 mai 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.widget.editor;

import java.io.File;

import javax.swing.event.DocumentListener;

/**
 * @author poussin
 * 
 */

public interface EditorInterface {

    /**
     * Add listener
     * 
     * @param listener
     */
    public void addDocumentListener(DocumentListener listener);

    /**
     * Remove listener
     * 
     * @param listener
     */
    public void removeDocumentListener(DocumentListener listener);

    /**
     * if return true, this editor support this file type. Default implantation
     * return true
     * 
     * @param file
     * @return if return true, this editor support this file type.
     */
    public boolean accept(File file);

    /**
     * indicate if current opened file has been modified
     * 
     * @return true if currend file is modified
     */
    public boolean isModified();

    /**
     * Replace the current edited file by file passed in argument.
     * 
     * @param file the file to open
     * @return true if file has been opened
     */
    public boolean open(File file);

    /**
     * Replace the current edited file by file passed in argument
     * 
     * @param file the file to open
     * @return true if file has been saved and reopen with new name
     */
    public boolean saveAs(File file);

    /**
     * Return the current content text of the editor as String
     * 
     * @return Return the current content text of the editor as String
     */
    public String getText();

    /**
     * Set all text with text in argument
     * 
     * @param text test to set
     */
    public void setText(String text);
}
