package org.nuiton.validator.bean.simple;
/*
 * #%L
 * Nuiton Utils :: Nuiton Validator
 * $Id: SimpleBeanValidatorEvent.java 2395 2012-08-11 07:54:22Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.6.4/nuiton-validator/src/main/java/org/nuiton/validator/bean/simple/SimpleBeanValidatorEvent.java $
 * %%
 * Copyright (C) 2011 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.AbstractValidatorEvent;

/**
 * Event to be fired when some messages changed on a given field / scope of a bean.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.2
 */
public class SimpleBeanValidatorEvent extends AbstractValidatorEvent<SimpleBeanValidator<?>> {

    private static final long serialVersionUID = 1L;

    public SimpleBeanValidatorEvent(SimpleBeanValidator<?> source,
                                    String field,
                                    NuitonValidatorScope scope,
                                    String[] messagestoAdd,
                                    String[] messagestoDelete) {
        super(source, field, scope, messagestoAdd, messagestoDelete);
    }

    @Override
    public Object getBean() {
        return getSource().getBean();
    }
}
