/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.version;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.util.version.VersionBuilder;
import org.nuiton.util.version.VersionComparator;
import org.nuiton.util.version.Versions;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    public static final Version VZERO = VersionBuilder.create().build();
    protected static final VersionComparator VERSION_COMPARATOR = new VersionComparator();
    public static final char DEFAULT_JOIN_COMPONANT_SEPARATOR = '.';
    protected final List<VersionComponant> componants;
    protected final List<String> componantSeparators;
    protected final boolean snapshot;
    protected transient String version;

    protected Version(List<VersionComponant> componants, List<String> componantSeparators, boolean snapshot) {
        this.componantSeparators = Collections.unmodifiableList(new ArrayList<String>(componantSeparators));
        this.componants = Collections.unmodifiableList(new ArrayList<VersionComponant>(componants));
        this.snapshot = snapshot;
    }

    public List<VersionComponant> getComponants() {
        return this.componants;
    }

    public List<String> getComponantSeparators() {
        return this.componantSeparators;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public int getComponantCount() {
        return this.componants.size();
    }

    public int getNumberComponant(int componantPosition) {
        VersionComponant comparable = this.getComponant(componantPosition);
        Preconditions.checkState(comparable instanceof NumberVersionComponant, "componant at " + componantPosition + " for version " + this + " is not a number (" + comparable + ")");
        return (Integer)comparable.getValue();
    }

    public String getTextComponant(int componantPosition) {
        VersionComponant comparable = this.getComponant(componantPosition);
        Preconditions.checkState(comparable instanceof StringVersionComponant, "componant at " + componantPosition + " for version " + this + " is not a string (" + comparable + ")");
        return (String)comparable.getValue();
    }

    public VersionComponant getComponant(int level) {
        Preconditions.checkArgument(level > 0 || level < this.getComponantCount(), "not a valid level " + level + " for the Version " + this);
        return this.componants.get(level);
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = String.valueOf(this.componants.get(0).getValue());
            int nb = this.componantSeparators.size();
            for (int i = 0; i < nb; ++i) {
                this.version = this.version + this.componantSeparators.get(i);
                this.version = this.version + this.componants.get(i + 1).getValue();
            }
            if (this.snapshot) {
                this.version = this.version + SNAPSHOT_SUFFIX;
            }
        }
        return this.version;
    }

    public String getValidName() {
        String validName = this.getVersion();
        validName = validName.replaceAll("\\.|-", "_");
        return validName;
    }

    @Deprecated
    public Version increments() {
        Version newVersion = Versions.increments(this);
        return newVersion;
    }

    @Deprecated
    public Version increments(char componantSeperator) {
        Version newVersion = Versions.increments(this, componantSeperator);
        return newVersion;
    }

    @Deprecated
    public Version increments(int componantPosition) {
        Version newVersion = Versions.increments(this, componantPosition);
        return newVersion;
    }

    @Deprecated
    public Version decrements(int componantPosition) {
        Version newVersion = Versions.decrements(this, componantPosition);
        return newVersion;
    }

    @Override
    public int compareTo(Version o) {
        int result = VERSION_COMPARATOR.compare(this, o);
        return result;
    }

    public boolean beforeOrequals(Version o) {
        int result = this.compareTo(o);
        return result <= 0;
    }

    public boolean before(Version o) {
        int result = this.compareTo(o);
        return result < 0;
    }

    public boolean afterOrEquals(Version o) {
        int result = this.compareTo(o);
        return result >= 0;
    }

    public boolean after(Version o) {
        int result = this.compareTo(o);
        return result > 0;
    }

    public String toString() {
        return this.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        int result = this.componants.hashCode();
        result = 31 * result + (this.snapshot ? 1 : 0);
        return result;
    }

    protected VersionComponant getLastComponant() {
        return this.componants.get(this.getComponantCount() - 1);
    }

    public static class StringVersionComponant
    implements VersionComponant<String, StringVersionComponant> {
        private static final long serialVersionUID = 1L;
        protected final boolean preRelease;
        protected final String value;
        protected final String lowerCaseValue;

        public StringVersionComponant(boolean preRelease, String value) {
            this.preRelease = preRelease;
            this.value = value;
            this.lowerCaseValue = value.toLowerCase();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringVersionComponant)) {
                return false;
            }
            return this.compareTo((StringVersionComponant)o) == 0;
        }

        public int hashCode() {
            int result = this.preRelease ? 1 : 0;
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public boolean isPreRelease() {
            return this.preRelease;
        }

        @Override
        public int compareTo(StringVersionComponant o) {
            int result = ObjectUtils.notEqual(this.preRelease, o.preRelease) ? (this.preRelease ? -1 : 1) : this.lowerCaseValue.compareTo(o.lowerCaseValue);
            return result;
        }
    }

    public static class NumberVersionComponant
    implements VersionComponant<Integer, NumberVersionComponant> {
        private static final long serialVersionUID = 1L;
        protected final Integer value;

        public NumberVersionComponant(Integer value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NumberVersionComponant)) {
                return false;
            }
            return this.compareTo((NumberVersionComponant)o) == 0;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public int compareTo(NumberVersionComponant o) {
            return this.value.compareTo(o.value);
        }
    }

    public static interface VersionComponant<C extends Comparable<C>, V extends VersionComponant>
    extends Serializable,
    Comparable<V> {
        public C getValue();
    }
}

