/*
 * #%L
 * Nuiton Utils :: Maven Report Plugin
 * $Id: AggregateApplicationConfigReport.java 2358 2012-06-11 08:36:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.5/nuiton-utils-maven-report-plugin/src/main/java/org/nuiton/util/plugin/report/AggregateApplicationConfigReport.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.plugin.report;

import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.util.ApplicationConfigProvider;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Generates a report for declarated application config via the
 * {@link ApplicationConfigProvider} mecanism on a aggregate mojo.
 * <p/>
 * For each configuration, you can find all his options and actions.
 *
 * @author tchemit <chemit@codelutin.com>
 * @goal aggregate-application-config-report
 * @requiresDependencyResolution runtime
 * @requiresProject true
 * @aggregator
 * @since 2.4.9
 */
public class AggregateApplicationConfigReport extends AbstractApplicationConfigReport {

    /**
     * The projects in the reactor.
     *
     * @parameter property="reactorProjects"
     * @readonly
     * @required
     * @since 1.0
     */
    protected List<?> reactorProjects;

    @Override
    protected ClassLoader createClassLoader() throws MavenReportException {
        Set<String> paths = new HashSet<String>();

        for (Object o : reactorProjects) {
            MavenProject p = (MavenProject) o;
            List runtimeClasspathElements = null;
            try {
                runtimeClasspathElements = p.getRuntimeClasspathElements();
                paths.addAll(runtimeClasspathElements);
            } catch (DependencyResolutionRequiredException e) {
                throw new MavenReportException("Could not obtain dependencies for project " + p);
            }
        }
        return createClassLoader(paths);
    }
}
