/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.io;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.ServiceLoader;
import org.nuiton.config.io.ApplicationConfigIO;
import org.nuiton.config.io.ApplicationConfigReadFormat;
import org.nuiton.config.io.ApplicationConfigReadPropertiesException;
import org.nuiton.config.io.ApplicationConfigWritePropertiesException;

public class ApplicationConfigIOHelper
implements ApplicationConfigIO {
    private final ApplicationConfigIO delegate;

    public ApplicationConfigIOHelper(ApplicationConfigReadFormat readFormat) {
        if (readFormat == null) {
            throw new NullPointerException("Can't init with null readFormat");
        }
        ServiceLoader<ApplicationConfigIO> loader = ServiceLoader.load(ApplicationConfigIO.class);
        ApplicationConfigIO delegate = null;
        for (ApplicationConfigIO applicationConfigIO : loader) {
            if (!applicationConfigIO.accept(readFormat)) continue;
            delegate = applicationConfigIO;
        }
        if (delegate == null) {
            throw new IllegalStateException("Could not find ApplicationConfigIO implementation for format: " + (Object)((Object)readFormat));
        }
        this.delegate = delegate;
    }

    @Override
    public boolean accept(ApplicationConfigReadFormat readFormat) {
        return true;
    }

    @Override
    public Properties readProperties(URL url, String encoding) throws ApplicationConfigReadPropertiesException {
        return this.delegate.readProperties(url, encoding);
    }

    @Override
    public void writeProperties(Properties properties, File file, String encoding, String comment) throws ApplicationConfigWritePropertiesException {
        this.delegate.writeProperties(properties, file, encoding, comment);
    }
}

