/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.header;

import org.nuiton.license.plugin.header.FileHeader;
import org.nuiton.license.plugin.header.FileHeaderFilter;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

public class UpdateFileHeaderFilter
extends FileHeaderFilter {
    protected boolean updateDescription;
    protected boolean updateLicense;
    protected boolean updateCopyright;

    @Override
    protected FileHeader getNewHeader(FileHeader oldHeader) {
        FileHeader result = new FileHeader();
        FileHeader newHeader = this.getFileHeader();
        FileHeaderTransformer transformer = this.getTransformer();
        boolean modified = false;
        result.setDescription(oldHeader.getDescription());
        result.setCopyrightFirstYear(oldHeader.getCopyrightFirstYear());
        result.setCopyrightLastYear(oldHeader.getCopyrightLastYear());
        result.setCopyrightHolder(oldHeader.getCopyrightHolder());
        result.setLicense(oldHeader.getLicense());
        if (this.isUpdateDescription() && !transformer.isDescriptionEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("description has changed from [" + oldHeader.getDescription() + "] to [" + newHeader.getDescription() + "]"));
            }
            modified = true;
            result.setDescription(newHeader.getDescription());
        }
        if (this.isUpdateCopyright() && !transformer.isCopyrightEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("copyright has changed from [" + oldHeader.getCopyright() + "] to [" + newHeader.getCopyright() + "]"));
            }
            modified = true;
            result.setCopyrightFirstYear(result.getCopyrightFirstYear());
            result.setCopyrightLastYear(result.getCopyrightLastYear());
            result.setCopyrightHolder(result.getCopyrightHolder());
        }
        if (this.isUpdateLicense() && !transformer.isLicenseEquals(oldHeader, newHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("license has changed from [" + oldHeader.getLicense() + "] to [" + newHeader.getLicense() + "]"));
            }
            modified = true;
            result.setLicense(newHeader.getLicense());
        }
        if (!modified) {
            result = null;
        }
        return result;
    }

    @Override
    @Deprecated
    protected String treateHeader(String ch) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("header\n" + ch));
        }
        FileHeaderTransformer transformer = this.getTransformer();
        String unbox = transformer.unboxComent(ch);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("unboxed comment header\n" + unbox));
        }
        FileHeader fileHeader = transformer.toFileHeader(unbox);
        fileHeader.setLicense(this.getFileHeader().getLicense());
        if (this.isUpdateCopyright()) {
            // empty if block
        }
        String newHeader = transformer.toString(fileHeader);
        newHeader = transformer.boxProcessTag(newHeader);
        newHeader = transformer.boxComment(newHeader, false);
        int index = newHeader.indexOf(transformer.getProcessStartTag());
        int lastIndex = newHeader.lastIndexOf(transformer.getProcessEndTag()) + transformer.getProcessEndTag().length();
        String result = newHeader.substring(index, lastIndex);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("updated Header =\n" + result));
        }
        return result;
    }

    public boolean isUpdateCopyright() {
        return this.updateCopyright;
    }

    public void setUpdateCopyright(boolean updateCopyright) {
        this.updateCopyright = updateCopyright;
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }

    public boolean isUpdateLicense() {
        return this.updateLicense;
    }

    public void setUpdateLicense(boolean updateLicense) {
        this.updateLicense = updateLicense;
    }
}

