/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

public class CommentStyleListMojo
extends AbstractLicenseMojo {
    private boolean detail;
    private Map<String, FileHeaderTransformer> transformers;

    protected void init() throws Exception {
    }

    public void doAction() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           maven-license-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        ArrayList<String> names = new ArrayList<String>(this.transformers.keySet());
        Collections.sort(names);
        int maxLength = 0;
        for (String name : names) {
            if (name.length() <= maxLength) continue;
            maxLength = name.length();
        }
        String pattern = "  - %1$-" + maxLength + "s : %2$s\n";
        buffer.append("List of available comment styles:\n\n");
        for (String transformerName : names) {
            FileHeaderTransformer transformer = this.transformers.get(transformerName);
            buffer.append(String.format(pattern, transformerName, transformer.getDescription()));
            if (!this.detail) continue;
            buffer.append("\n   example : \n");
            buffer.append(transformer.boxComment("header", true));
            buffer.append('\n');
        }
        this.getLog().info((CharSequence)buffer.toString());
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public Map<String, FileHeaderTransformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Map<String, FileHeaderTransformer> transformers) {
        this.transformers = transformers;
    }
}

