/*
 * $Id$
 */

package org.nuiton.license.plugin.model.descriptor;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         A Header represents a set of resources using the same
 * {@code header type}.
 *         <p/>
 *         The licenseName can be inherited by the mainLicense of
 * the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Header
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *               The license to apply in this set. If not fill,
     * will use
     *               the main license.
     *               
     *           
     */
    private String licenseName;

    /**
     * 
     *             
     *             The style of the comment which box the header to
     * generate (or updates).
     *             
     *           
     */
    private String commentStyle;

    /**
     * Field fileSets.
     */
    private java.util.List<FileSet> fileSets;

    /**
     * 
     *             
     *             Specifies a single file sets to include in the
     * license set. A fileSet is
     *             specified by providing one or more of
     * &lt;licenseSet&gt; subelements.
     *             
     *           
     */
    private FileSet fileSet;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFileSet.
     * 
     * @param fileSet
     */
    public void addFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Header.addFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().add( fileSet );
    } //-- void addFileSet( FileSet )

    /**
     * Get 
     *             
     *             The style of the comment which box the header to
     * generate (or updates).
     *             
     *           
     * 
     * @return String
     */
    public String getCommentStyle()
    {
        return this.commentStyle;
    } //-- String getCommentStyle()

    /**
     * Get 
     *             
     *             Specifies a single file sets to include in the
     * license set. A fileSet is
     *             specified by providing one or more of
     * &lt;licenseSet&gt; subelements.
     *             
     *           
     * 
     * @return FileSet
     */
    public FileSet getFileSet()
    {
        return this.fileSet;
    } //-- FileSet getFileSet()

    /**
     * Method getFileSets.
     * 
     * @return List
     */
    public java.util.List<FileSet> getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList<FileSet>();
        }

        return this.fileSets;
    } //-- java.util.List<FileSet> getFileSets()

    /**
     * Get 
     *             
     *               The license to apply in this set. If not fill,
     * will use
     *               the main license.
     *               
     *           
     * 
     * @return String
     */
    public String getLicenseName()
    {
        return this.licenseName;
    } //-- String getLicenseName()

    /**
     * Method removeFileSet.
     * 
     * @param fileSet
     */
    public void removeFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Header.removeFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().remove( fileSet );
    } //-- void removeFileSet( FileSet )

    /**
     * Set 
     *             
     *             The style of the comment which box the header to
     * generate (or updates).
     *             
     *           
     * 
     * @param commentStyle
     */
    public void setCommentStyle( String commentStyle )
    {
        this.commentStyle = commentStyle;
    } //-- void setCommentStyle( String )

    /**
     * Set 
     *             
     *             Specifies a single file sets to include in the
     * license set. A fileSet is
     *             specified by providing one or more of
     * &lt;licenseSet&gt; subelements.
     *             
     *           
     * 
     * @param fileSet
     */
    public void setFileSet( FileSet fileSet )
    {
        this.fileSet = fileSet;
    } //-- void setFileSet( FileSet )

    /**
     * Set 
     *             
     *             Specifies file sets to include in the license
     * set. A fileSet is
     *             specified by providing one or more of
     * &lt;licenseSet&gt; subelements.
     *             
     *           
     * 
     * @param fileSets
     */
    public void setFileSets( java.util.List<FileSet> fileSets )
    {
        this.fileSets = fileSets;
    } //-- void setFileSets( java.util.List )

    /**
     * Set 
     *             
     *               The license to apply in this set. If not fill,
     * will use
     *               the main license.
     *               
     *           
     * 
     * @param licenseName
     */
    public void setLicenseName( String licenseName )
    {
        this.licenseName = licenseName;
    } //-- void setLicenseName( String )


}
