/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.SparseArrayVectorIterator;
import org.nuiton.math.matrix.SparseVector;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorForEachFunction;
import org.nuiton.math.matrix.VectorIterator;

public class DoubleSparseArrayVector
implements SparseVector {
    protected double defaultValue = 0.0;
    protected long capacity = 0L;
    protected int assignedSize = 0;
    protected long[] position;
    protected double[] values;

    public DoubleSparseArrayVector() {
    }

    public DoubleSparseArrayVector(long capacity) {
        this.init(capacity);
    }

    public DoubleSparseArrayVector(long capacity, double defaultValue) {
        this(capacity);
        this.defaultValue = defaultValue;
    }

    @Override
    public void init(long capacity) {
        if (this.values == null) {
            this.capacity = capacity;
            this.values = new double[8];
            this.position = new long[8];
            Arrays.fill(this.position, Long.MAX_VALUE);
        }
    }

    @Override
    public String getInfo() {
        return "Double vector sparse: " + this.assignedSize + "/" + this.size();
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public long[] getAssignedPosition() {
        return this.position;
    }

    @Override
    public double[] getAssignedValue() {
        return this.values;
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.assignedSize;
    }

    @Override
    public long size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        long max = this.capacity - (long)this.assignedSize;
        double result = this.defaultValue;
        if (this.capacity > 2L * max) {
            double[] tmp = Arrays.copyOf(this.values, this.assignedSize);
            Arrays.sort(tmp);
            int count = 1;
            double old = tmp[0];
            double current = tmp[0];
            for (int i = 1; max < (long)(tmp.length - i + count) && i < tmp.length; ++i) {
                current = tmp[i];
                if (current == old) {
                    ++count;
                    continue;
                }
                if ((long)count > max) {
                    max = count;
                    result = old;
                }
                count = 1;
                old = current;
            }
            if ((long)count > max) {
                max = count;
                result = current;
            }
        }
        return result;
    }

    protected void checkPos(long pos) {
        if (pos < 0L || pos >= this.capacity) {
            throw new IllegalArgumentException("pos " + pos + " is not in [0, " + this.capacity + "]");
        }
    }

    @Override
    public double getValue(long pos) {
        this.checkPos(pos);
        double result = this.defaultValue;
        int index = this.findIndex(pos);
        if (index >= 0) {
            result = this.values[index];
        }
        return result;
    }

    @Override
    public void setValue(long pos, double value) {
        this.checkPos(pos);
        int index = this.findIndex(pos);
        if (index >= 0) {
            if (value == this.defaultValue) {
                this.removeElementAt(index);
            } else {
                this.values[index] = value;
            }
        } else if (value != this.defaultValue) {
            index = -index - 1;
            this.addElementAt(index, pos, value);
        }
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DoubleSparseArrayVector && this.defaultValue == ((DoubleSparseArrayVector)o).defaultValue) {
            DoubleSparseArrayVector other = (DoubleSparseArrayVector)o;
            result = Arrays.equals(this.position, other.position) && Arrays.equals(this.values, other.values);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = this.size() == other.size();
            int i = 0;
            while ((long)i < this.size() && result) {
                result = this.getValue(i) == other.getValue(i);
                ++i;
            }
        }
        return result;
    }

    public int hashCode() {
        return Long.hashCode(this.size());
    }

    protected int findIndex(long pos) {
        return Arrays.binarySearch(this.position, pos);
    }

    protected void ensureCapacity(int mincap) {
        if (mincap > this.position.length) {
            int newcap = (int)((long)this.position.length * 3L / 2L + 1L);
            long[] oldPosition = this.position;
            this.position = new long[newcap >= mincap ? newcap : mincap];
            System.arraycopy(oldPosition, 0, this.position, 0, this.assignedSize);
            for (int i = this.assignedSize; i < this.position.length; ++i) {
                this.position[i] = Long.MAX_VALUE;
            }
            double[] oldValues = this.values;
            this.values = new double[newcap >= mincap ? newcap : mincap];
            System.arraycopy(oldValues, 0, this.values, 0, this.assignedSize);
        }
    }

    protected void addElementAt(int index, long element, double value) {
        this.ensureCapacity(this.assignedSize + 1);
        int numtomove = this.assignedSize - index;
        System.arraycopy(this.position, index, this.position, index + 1, numtomove);
        this.position[index] = element;
        System.arraycopy(this.values, index, this.values, index + 1, numtomove);
        this.values[index] = value;
        ++this.assignedSize;
    }

    protected void removeElementAt(int index) {
        int numtomove = this.assignedSize - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.position, index + 1, this.position, index, numtomove);
            System.arraycopy(this.values, index + 1, this.values, index, numtomove);
        }
        --this.assignedSize;
        this.position[this.assignedSize] = Long.MAX_VALUE;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleSparseArrayVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        DoubleSparseArrayVector fbv = (DoubleSparseArrayVector)v;
        this.capacity = fbv.capacity;
        this.defaultValue = fbv.defaultValue;
        this.assignedSize = fbv.assignedSize;
        this.position = new long[this.assignedSize];
        this.values = new double[this.assignedSize];
        System.arraycopy(fbv.position, 0, this.position, 0, this.assignedSize);
        System.arraycopy(fbv.values, 0, this.values, 0, this.assignedSize);
    }

    @Override
    public void map(MapFunction f) {
        this.defaultValue = f.apply(this.defaultValue);
        for (int i = this.assignedSize - 1; i >= 0; --i) {
            double value = f.apply(this.values[i]);
            if (value == this.defaultValue) {
                this.removeElementAt(i);
                continue;
            }
            this.values[i] = value;
        }
    }

    @Override
    public VectorIterator iterator() {
        return new SparseArrayVectorIterator(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new SparseArrayVectorIterator(this, 0.0);
    }

    @Override
    public void forEachNotZero(VectorForEachFunction f) {
        if (this.defaultValue == 0.0) {
            long max = this.getNumberOfAssignedValue();
            for (long i = 0L; i < max; ++i) {
                f.apply(i, this.getValue(i));
            }
        } else {
            SparseVector.super.forEachNotZero(f);
        }
    }
}

