/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.IdAbles;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.IssueCollectorConfiguration;
import org.nuiton.jredmine.service.RedmineService;
import org.nuiton.jredmine.service.RedmineServiceException;

public class IssuesCollector {
    protected final Log log;
    protected final boolean verbose;
    protected Integer maxEntries;
    protected List<Integer> versionIds;
    protected List<Integer> priorityIds;
    protected List<Integer> statusIds;
    protected List<Integer> categoryIds;
    protected List<Integer> trackerIds;
    protected Issue[] issues;

    public IssuesCollector(Log log, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
    }

    public void collect(RedmineService service, IssueCollectorConfiguration config) throws RedmineServiceException {
        this.clearFilters();
        this.prepareFilters(service, config);
        String projectId = config.getProjectId();
        if (config.isVerbose()) {
            this.log.info((CharSequence)("report project : " + projectId));
        }
        Version[] versions = service.getVersions(projectId);
        if (this.versionIds != null) {
            versions = (Version[])IdAbles.byIds(Version.class, (IdAble[])versions, (Integer[])this.versionIds.toArray(new Integer[this.versionIds.size()]));
        }
        int nbIssues = 0;
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        for (Version v : versions) {
            Issue[] currentIssues;
            if (this.verbose) {
                this.log.info((CharSequence)("discover all issues for version " + v.getName()));
            }
            for (Issue i : currentIssues = service.getIssues(projectId, v.getName())) {
                if (!this.canIncludeIssue(i)) continue;
                issueList.add(i);
                if (this.maxEntries != null && ++nbIssues >= this.maxEntries) break;
            }
            if (this.maxEntries != null && nbIssues >= this.maxEntries) break;
        }
        this.issues = issueList.toArray(new Issue[issueList.size()]);
    }

    public Integer getMaxEntries() {
        return this.maxEntries;
    }

    public List<Integer> getPriorityIds() {
        return this.priorityIds;
    }

    public List<Integer> getStatusIds() {
        return this.statusIds;
    }

    public List<Integer> getCategoryIds() {
        return this.categoryIds;
    }

    public List<Integer> getVersionIds() {
        return this.versionIds;
    }

    public List<Integer> getTrackerIds() {
        return this.trackerIds;
    }

    public Issue[] getIssues() {
        return this.issues;
    }

    public void clearFilters() {
        this.maxEntries = null;
        this.priorityIds = null;
        this.statusIds = null;
        this.categoryIds = null;
        this.trackerIds = null;
        this.versionIds = null;
        this.issues = null;
    }

    protected void prepareFilters(RedmineService service, IssueCollectorConfiguration config) throws RedmineServiceException {
        int id;
        List<Object> svs;
        this.maxEntries = config.getMaxEntries();
        if (this.maxEntries == 0) {
            this.maxEntries = null;
        } else if (config.isVerbose()) {
            this.log.info((CharSequence)("limit issues : " + this.maxEntries));
        }
        String projectId = config.getProjectId();
        String tmp = config.getVersionNames();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("version to filter : " + tmp));
        }
        if (tmp != null && !tmp.trim().isEmpty()) {
            if (config.isOnlyCurrentVersion()) {
                this.log.warn((CharSequence)"will not filter on versions while using the flag 'onlyCurrentVersion'");
            } else {
                this.versionIds = new ArrayList<Integer>();
                svs = Arrays.asList(tmp.split(","));
                for (Version version : service.getVersions(projectId)) {
                    if (!svs.contains(version.getName())) continue;
                    this.versionIds.add(version.getId());
                    if (!config.isVerbose()) continue;
                    this.log.info((CharSequence)("use version " + version.getName()));
                }
            }
        }
        if (config.isOnlyCurrentVersion()) {
            Version currentVersion = service.getVersion(projectId, config.getVersionId());
            this.versionIds = Arrays.asList(currentVersion.getId());
        }
        tmp = config.getStatusIds();
        this.statusIds = null;
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.statusIds = new ArrayList<Integer>();
            svs = this.toIntegerList(tmp.split(","));
            for (Version version : service.getIssueStatuses()) {
                id = version.getId();
                if (!svs.contains(id)) continue;
                this.statusIds.add(id);
                if (!config.isVerbose()) continue;
                this.log.info((CharSequence)("use status " + version.getName()));
            }
        }
        if ((tmp = config.getPriorityIds()) != null && !tmp.trim().isEmpty()) {
            this.priorityIds = new ArrayList<Integer>();
            svs = this.toIntegerList(tmp.split(","));
            for (Version version : service.getIssuePriorities()) {
                id = version.getId();
                if (!svs.contains(id)) continue;
                this.priorityIds.add(id);
                if (!config.isVerbose()) continue;
                this.log.info((CharSequence)("use priority " + version.getName()));
            }
        }
        if ((tmp = config.getCategoryIds()) != null && !tmp.trim().isEmpty()) {
            this.categoryIds = new ArrayList<Integer>();
            svs = this.toIntegerList(tmp.split(","));
            for (Version version : service.getIssueCategories(projectId)) {
                id = version.getId();
                if (!svs.contains(id)) continue;
                this.categoryIds.add(id);
                if (!config.isVerbose()) continue;
                this.log.info((CharSequence)("use category " + version.getName()));
            }
        }
        if ((tmp = config.getTrackerIds()) != null && !tmp.trim().isEmpty()) {
            this.trackerIds = new ArrayList<Integer>();
            svs = this.toIntegerList(tmp.split(","));
            for (Version version : service.getTrackers(projectId)) {
                id = version.getId();
                if (!svs.contains(id)) continue;
                this.trackerIds.add(id);
                if (!config.isVerbose()) continue;
                this.log.info((CharSequence)("use tracker " + version.getName()));
            }
        }
    }

    protected boolean canIncludeIssue(Issue i) {
        if (this.statusIds != null && !this.statusIds.contains(i.getStatusId())) {
            return false;
        }
        if (this.priorityIds != null && !this.priorityIds.contains(i.getPriorityId())) {
            return false;
        }
        if (this.categoryIds != null && !this.categoryIds.contains(i.getCategoryId())) {
            return false;
        }
        return this.trackerIds == null || this.trackerIds.contains(i.getTrackerId());
    }

    protected List<Integer> toIntegerList(String[] strIds) {
        int length = strIds.length;
        ArrayList<Integer> r = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            r.add(Integer.valueOf(strIds[i]));
        }
        return r;
    }
}

