/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.jredmine.client.RedmineClientAuthConfiguration;
import org.nuiton.jredmine.plugin.SkipOrRunOnlyOnceAware;
import org.nuiton.jredmine.service.RedmineService;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.plugin.AbstractPlugin;

public abstract class AbstractRedmineMojo
extends AbstractPlugin
implements RedmineServiceConfiguration {
    public static final String REDMINE_SYSTEM = "redmine";
    @Parameter(property="redmine.url")
    protected URL url;
    @Parameter(property="redmine.apiKey")
    protected String apiKey;
    @Parameter(property="redmine.username")
    protected String username;
    @Parameter(property="redmine.password")
    protected String password;
    @Parameter(property="redmine.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="redmine.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="redmine.safe", defaultValue="true")
    protected boolean safe;
    @Component
    protected MavenProject project;
    @Component
    protected MavenSession session;
    @Component
    protected RedmineService service;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean serviceInit;
    protected boolean initOk = true;
    private RedmineClientAuthConfiguration authConfiguration;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public RedmineClientAuthConfiguration getAuthConfiguration() {
        return this.authConfiguration;
    }

    public void setAuthConfiguration(RedmineClientAuthConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    protected void init() throws Exception {
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            throw new MojoExecutionException("No Issue Management set.");
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            throw new MojoExecutionException("No URL set in Issue Management.");
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase(REDMINE_SYSTEM)) {
            throw new MojoExecutionException("Redmine's Plugin only supports 'redmine' Issue Management system.");
        }
        if (this.url == null || this.url.toString().isEmpty()) {
            this.url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + this.url));
            }
        }
        this.setUrl(this.url);
        this.authConfiguration = RedmineClientAuthConfiguration.newConf((String)this.apiKey, (String)this.username, (String)this.password);
        if (this.verbose) {
            if (this.authConfiguration.isUseApiKey()) {
                this.getLog().info((CharSequence)("Redmine configuration :\n>> host     : " + this.getUrl() + "\n>> apiKey: " + this.apiKey));
            } else if (this.authConfiguration.isUseUsername()) {
                this.getLog().info((CharSequence)("Redmine configuration :\n>> host     : " + this.getUrl() + "\n>> username : " + this.username));
            } else {
                this.getLog().info((CharSequence)("Redmine anonymous configuration :\n>> host     : " + this.getUrl()));
            }
        }
        try {
            this.service.init((RedmineServiceConfiguration)this);
            this.serviceInit = true;
        }
        catch (Exception e) {
            if (this.safe) {
                throw e;
            }
            this.serviceInit = false;
            this.initOk = false;
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getUrl() + "]"), (Throwable)e);
        }
    }

    protected boolean checkSkip() {
        if (this instanceof SkipOrRunOnlyOnceAware) {
            SkipOrRunOnlyOnceAware m = (SkipOrRunOnlyOnceAware)((Object)this);
            if (m.isGoalSkip()) {
                this.getLog().info((CharSequence)("Skipping goal (" + m.getSkipProperty() + " flag is on)."));
                return false;
            }
            if (m.isRunOnce() && m.isRunOnceDone()) {
                this.getLog().info((CharSequence)"Skipping goal (runOnce flag is on, and was already executed).");
                return false;
            }
        }
        if (!this.serviceInit) {
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getUrl() + "]"));
            return false;
        }
        return true;
    }

    protected void afterExecute() {
        this.closeService();
    }

    protected abstract void doAction() throws Exception;

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void closeService() {
        if (this.service != null) {
            try {
                this.service.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    protected void failIfSafe(String message) throws MojoExecutionException {
        if (this.safe) {
            throw new MojoExecutionException(message);
        }
    }
}

