/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Author;
import org.apache.maven.plugins.changes.model.Body;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.Properties;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.plugins.changes.model.io.xpp3.ChangesXpp3Writer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.IdAbles;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProjectAndVersion;
import org.nuiton.jredmine.plugin.IssueCollectorConfiguration;
import org.nuiton.jredmine.plugin.IssuesCollector;
import org.nuiton.jredmine.plugin.SkipOrRunOnlyOnceAware;
import org.nuiton.jredmine.service.RedmineServiceException;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate-changes", requiresOnline=true, requiresProject=true)
public class GenerateChangesMojo
extends AbstractRedmineMojoWithProjectAndVersion
implements IssueCollectorConfiguration,
SkipOrRunOnlyOnceAware {
    @Parameter(property="redmine.anonymous", defaultValue="true")
    protected boolean anonymous;
    @Parameter(property="redmine.xmlPath", defaultValue="${basedir}/src/changes/changes.xml", required=true)
    protected File xmlPath;
    @Parameter(property="releaseDescription")
    protected String releaseDescription;
    @Parameter(property="changesTitle", defaultValue="${project.description}", required=true)
    protected String changesTitle;
    @Parameter(property="redmine.onlyCurrentVersion", defaultValue="false")
    protected boolean onlyCurrentVersion;
    @Parameter(property="redmine.actionMapping", required=true)
    protected String actionMapping;
    @Parameter(property="redmine.statusIds")
    protected String statusIds;
    @Parameter(property="redmine.categoryIds")
    protected String categoryIds;
    @Parameter(property="redmine.skipGenerateChanges", defaultValue="false")
    protected boolean skipGenerateChanges;
    @Parameter(property="redmine.generateOnce", defaultValue="true")
    protected boolean generateOnce;
    @Parameter(property="redmine.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    private static File cacheChangesFile;
    protected Map<Integer, String> trackerToAction;
    protected Map<String, String> filters;
    private Version[] versions;
    protected boolean runOnceDone;

    public GenerateChangesMojo() {
        super(true, true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isOnlyCurrentVersion() {
        return this.onlyCurrentVersion;
    }

    @Override
    public int getMaxEntries() {
        return 0;
    }

    @Override
    public String getPriorityIds() {
        return null;
    }

    @Override
    public String getCategoryIds() {
        return this.filters.get("category");
    }

    @Override
    public String getVersionNames() {
        return this.filters.get("version");
    }

    @Override
    public String getStatusIds() {
        return this.filters.get("status");
    }

    @Override
    public String getTrackerIds() {
        return this.filters.get("tracker");
    }

    @Override
    public String getSkipProperty() {
        return "skipGenerateChanges";
    }

    @Override
    public boolean isGoalSkip() {
        return this.skipGenerateChanges;
    }

    @Override
    public boolean isRunOnce() {
        return this.generateOnce;
    }

    @Override
    public boolean isRunOnlyOnRoot() {
        return this.runOnlyOnRoot;
    }

    @Override
    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    @Override
    public boolean checkRunOnceDone() {
        Date buildStartTime = this.session == null ? null : this.session.getStartTime();
        Date newStartTime = cacheChangesFile != null && cacheChangesFile.exists() ? new Date(cacheChangesFile.lastModified()) : null;
        boolean needInvoke = this.needInvoke(this.isRunOnce(), this.runOnlyOnRoot, buildStartTime, newStartTime);
        return !needInvoke;
    }

    @Override
    protected void init() throws Exception {
        IssueStatus t;
        Integer id;
        IssueCategory[] categories;
        IssueStatus[] statuses;
        Tracker[] releaseTrackers;
        if (this.isGoalSkip()) {
            return;
        }
        if (this.xmlPath == null || this.xmlPath.getAbsolutePath().trim().isEmpty()) {
            throw new MojoExecutionException("required a xmlPath parameter");
        }
        if (StringUtils.isBlank((String)this.versionId)) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = this.isRunOnce() && this.checkRunOnceDone();
        if (this.runOnceDone) {
            return;
        }
        super.init();
        if (!this.safe && !this.initOk) {
            return;
        }
        try {
            releaseTrackers = this.service.getTrackers(this.projectId);
        }
        catch (RedmineServiceException e) {
            throw new MojoExecutionException("could not obtain trackers for reason " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            statuses = this.service.getIssueStatuses();
        }
        catch (RedmineServiceException e) {
            throw new MojoExecutionException("could not obtain statuses for reason " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            categories = this.service.getIssueCategories(this.projectId);
        }
        catch (RedmineServiceException e) {
            throw new MojoExecutionException("could not obtain categories for reason " + e.getMessage(), (Exception)((Object)e));
        }
        this.filters = new HashMap<String, String>();
        this.trackerToAction = new HashMap<Integer, String>();
        String[] entries = this.actionMapping.split(",");
        StringBuilder buffer = new StringBuilder();
        for (String entry : entries) {
            Object[] parts = entry.split(":");
            if (parts.length != 2) {
                throw new MojoExecutionException("the trackerMapping entry " + Arrays.toString(parts) + " is not well formed");
            }
            String action = parts[0].trim().toLowerCase();
            try {
                Actions.valueOf(action);
            }
            catch (Exception e) {
                throw new MojoExecutionException("the action " + action + " is unknown... authorized : " + Arrays.toString((Object[])Actions.values()));
            }
            Integer id2 = Integer.valueOf(((String)parts[1]).trim());
            Tracker t2 = (Tracker)IdAbles.byId((int)id2, (IdAble[])releaseTrackers);
            if (t2 == null) {
                throw new MojoExecutionException("could not obtain the tracker with id " + id2);
            }
            this.trackerToAction.put(id2, action);
            buffer.append(",").append(id2);
        }
        this.filters.put("tracker", buffer.substring(1));
        if (StringUtils.isNotBlank((String)this.statusIds)) {
            for (String s : this.statusIds.split(",")) {
                id = Integer.valueOf(s.trim());
                t = (IssueStatus)IdAbles.byId((int)id, (IdAble[])statuses);
                if (t != null) continue;
                throw new MojoExecutionException("could not obtain the status with id " + id);
            }
        }
        this.filters.put("status", this.statusIds);
        if (StringUtils.isNotBlank((String)this.categoryIds)) {
            for (String s : this.categoryIds.split(",")) {
                id = Integer.valueOf(s.trim());
                t = (IssueCategory)IdAbles.byId((int)id, (IdAble[])categories);
                if (t != null) continue;
                throw new MojoExecutionException("could not obtain the category with id " + id);
            }
            this.filters.put("category", this.categoryIds);
        }
        ArrayList<Version> versionList = new ArrayList<Version>();
        boolean versionExist = true;
        this.releaseVersion = this.getProjectVersion(this.versionId);
        if (this.releaseVersion == null) {
            versionExist = false;
            this.getLog().warn((CharSequence)("The version " + this.versionId + " does not exist on redmine"));
            this.releaseVersion = new Version();
            this.releaseVersion.setName(this.versionId);
            this.releaseVersion.setProjectId(this.releaseProject.getId());
        }
        if (this.onlyCurrentVersion) {
            versionList.add(this.releaseVersion);
        } else {
            buffer = new StringBuilder();
            for (Version v : this.getProjectVersions()) {
                String versionName = v.getName();
                boolean keep = true;
                if (!this.versionId.equals(versionName) && v.getEffectiveDate() == null) {
                    keep = false;
                }
                if (!keep) continue;
                buffer.append(",").append(v.getName());
                versionList.add(v);
            }
            if (!versionExist) {
                versionList.add(this.releaseVersion);
            }
        }
        this.versions = versionList.toArray(new Version[versionList.size()]);
        if (!this.onlyCurrentVersion) {
            this.filters.put("version", buffer.substring(1));
        }
    }

    @Override
    protected boolean checkSkip() {
        if (this.isRunOnceDone() && !this.xmlPath.exists()) {
            this.getLog().info((CharSequence)("Use already generated " + this.xmlPath.getName() + " (" + cacheChangesFile + ")"));
            try {
                this.createDirectoryIfNecessary(this.xmlPath.getParentFile());
                this.copyFile(cacheChangesFile, this.xmlPath);
            }
            catch (IOException e) {
                throw new IllegalStateException("could not copy already generated file " + this.xmlPath + " from " + cacheChangesFile);
            }
        }
        boolean b = super.checkSkip();
        return b;
    }

    @Override
    protected void doAction() throws Exception {
        File xmlParent = this.xmlPath.getParentFile();
        this.createDirectoryIfNecessary(xmlParent);
        if (this.releaseVersion.getEffectiveDate() == null) {
            this.getLog().debug((CharSequence)("The version " + this.versionId + " is not effective on redmine, should update effective-date property to today"));
            this.releaseVersion.setEffectiveDate(new Date());
        }
        this.getLog().info((CharSequence)("release project " + this.releaseProject.getName()));
        this.getLog().info((CharSequence)("release version " + this.releaseVersion.getName()));
        this.getLog().info((CharSequence)("release date " + this.releaseVersion.getEffectiveDate()));
        this.getLog().info((CharSequence)("release user " + this.releaseUser.getFirstname() + " " + this.releaseUser.getLastname()));
        IssuesCollector collector = new IssuesCollector(this.getLog(), this.verbose);
        try {
            collector.collect(this.service, this);
        }
        catch (RedmineServiceException ex) {
            collector.clearFilters();
            throw new MojoExecutionException("could not obtain issues for reason " + ex.getMessage(), (Exception)((Object)ex));
        }
        ChangesDocument doc = this.buildChangesDocument(this.releaseVersion, this.releaseUser, collector);
        ChangesXpp3Writer xppWriter = new ChangesXpp3Writer();
        XmlStreamWriter writer = new XmlStreamWriter(this.xmlPath);
        xppWriter.write((Writer)writer, doc);
        this.getLog().info((CharSequence)("File saved in " + this.xmlPath));
        cacheChangesFile = this.xmlPath;
    }

    protected ChangesDocument buildChangesDocument(Version version, User user, IssuesCollector collector) throws RedmineServiceException {
        ChangesDocument doc = new ChangesDocument();
        Properties properties = new Properties();
        Author author = new Author();
        author.setAuthorEmail(user.getMail());
        author.setName(user.getFirstname() + " " + user.getLastname());
        properties.setAuthor(author);
        properties.setTitle(this.changesTitle);
        doc.setProperties(properties);
        Body body = new Body();
        doc.setBody(body);
        Issue[] issues = collector.getIssues();
        for (Version v : this.versions) {
            boolean treateReleaseVersion = v.getId() == version.getId();
            Issue[] issuesForVersion = Issue.byVersionId((int)v.getId(), (Issue[])issues);
            Release release = new Release();
            body.addRelease(release);
            release.setVersion(v.getName());
            if (v.getEffectiveDate() != null) {
                release.setDateRelease(this.dateFormat.format(v.getEffectiveDate()));
            }
            if (v.getDescription() != null) {
                release.setDescription(v.getDescription());
            }
            if (treateReleaseVersion) {
                if (this.releaseDescription != null) {
                    release.setDescription(this.releaseDescription);
                }
                if (release.getDateRelease() == null) {
                    release.setDateRelease(this.dateFormat.format(new Date()));
                }
            }
            for (Map.Entry<Integer, String> entry : this.trackerToAction.entrySet()) {
                Issue[] issuesForTracker;
                String type = entry.getValue();
                for (Issue issue : issuesForTracker = Issue.byTrackerId((int)entry.getKey(), (Issue[])issuesForVersion)) {
                    User a;
                    Action action = new Action();
                    action.setSystem("redmine");
                    action.setAction(issue.getSubject());
                    action.setIssue(issue.getId() + "");
                    action.setType(type);
                    if (issue.getDueDate() != null) {
                        action.setDate(this.dateFormat.format(issue.getDueDate()));
                    } else if (this.verbose) {
                        this.getLog().warn((CharSequence)("issue " + issue.getSubject() + " has no dueDate..."));
                    }
                    int id = issue.getAuthorId();
                    if (id == 0) {
                        this.getLog().warn((CharSequence)("issue " + issue.getSubject() + " is not created to any user, this is not normal..."));
                        id = issue.getAuthorId();
                    }
                    if ((a = (User)IdAbles.byId((int)id, (IdAble[])this.users)) != null) {
                        action.setDueTo(a.getFirstname() + " " + a.getLastname());
                        action.setDueToEmail(a.getMail());
                    }
                    if ((id = issue.getAssignedToId()) == 0) {
                        this.getLog().warn((CharSequence)("issue " + issue.getSubject() + " is not assigned to any user, this is not normal..."));
                        id = issue.getAuthorId();
                    }
                    if ((a = (User)IdAbles.byId((int)id, (IdAble[])this.users)) != null) {
                        action.setDev(a.getLogin());
                    }
                    release.addAction(action);
                }
            }
        }
        return doc;
    }

    static enum Actions {
        add,
        fix,
        update,
        remove;

    }
}

