/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import java.util.Properties;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.nuiton.helper.plugin.ShareServerSecretPlugin;
import org.nuiton.jredmine.client.RedmineClientAuthConfiguration;
import org.nuiton.jredmine.service.RedmineService;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.plugin.AbstractPlugin;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="login", requiresOnline=true, requiresProject=true)
public class LoginMojo
extends AbstractPlugin
implements RedmineServiceConfiguration {
    @Parameter(property="redmine.url")
    protected URL url;
    @Parameter(property="redmine.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="redmine.checkLogin", defaultValue="false")
    protected boolean checkLogin;
    @Parameter(property="redmine.safe", defaultValue="true")
    protected boolean safe;
    @Parameter(property="redmine.serverId", required=true)
    protected String serverId;
    @Parameter(property="redmine.useApiKey", defaultValue="false")
    private boolean useApiKey;
    @Component
    protected MavenProject project;
    @Component
    protected Settings settings;
    @Component(hint="helper-maven-plugin")
    protected SecDispatcher sec;
    @Component
    protected RedmineService service;
    protected static ShareServerSecretPlugin plugin;
    private RedmineClientAuthConfiguration authConfiguration;
    private static final String REDMINE_USERNAME = "redmine.username";
    private static final String REDMINE_PASSWORD = "redmine.password";
    private static final String REDMINE_API_KEY = "redmine.apiKey";

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return null;
    }

    public void setEncoding(String encoding) {
    }

    public boolean isAnonymous() {
        return false;
    }

    public void setAnonymous(boolean anonymous) {
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public RedmineClientAuthConfiguration getAuthConfiguration() {
        return this.authConfiguration;
    }

    public void setAuthConfiguration(RedmineClientAuthConfiguration authConfiguration) {
        this.authConfiguration = authConfiguration;
    }

    protected void init() throws Exception {
        if (plugin == null) {
            plugin = new ShareServerSecretPlugin();
            plugin.setServerId(this.serverId);
            if (this.useApiKey) {
                plugin.setUsernameOut(REDMINE_API_KEY);
            } else {
                plugin.setUsernameOut(REDMINE_USERNAME);
                plugin.setPasswordOut(REDMINE_PASSWORD);
            }
            plugin.setRunOnce(true);
            plugin.setProject(this.project);
            plugin.setLog(this.getLog());
            plugin.setVerbose(this.isVerbose());
            plugin.setSettings(this.settings);
            plugin.setSec(this.sec);
            plugin.init();
        }
        if (!this.checkLogin) {
            return;
        }
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            throw new MojoExecutionException("No Issue Management set.");
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            throw new MojoExecutionException("No URL set in Issue Management.");
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase("redmine")) {
            throw new MojoExecutionException("Redmine's Plugin only supports 'redmine' Issue Management system.");
        }
        if (this.url == null || this.url.toString().isEmpty()) {
            this.url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + this.url));
            }
        }
        this.setUrl(this.url);
    }

    protected boolean checkSkip() {
        return plugin.checkSkip();
    }

    protected void doAction() throws Exception {
        this.getLog().info((CharSequence)("Obtain redmine login for serverId '" + this.serverId + "'"));
        plugin.setRunOnce(false);
        plugin.execute();
        plugin.setRunOnce(true);
        if (!this.checkLogin) {
            return;
        }
        Properties properties = this.project.getProperties();
        this.authConfiguration = RedmineClientAuthConfiguration.newConf((String)properties.getProperty(REDMINE_API_KEY), (String)properties.getProperty(REDMINE_USERNAME), (String)properties.getProperty(REDMINE_PASSWORD));
        try {
            this.service.init((RedmineServiceConfiguration)this);
        }
        catch (Exception e) {
            if (this.safe) {
                throw e;
            }
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getUrl() + "]"), (Throwable)e);
        }
        this.getLog().info((CharSequence)"Connection to redmine server successfull.");
    }

    protected void afterExecute() {
        if (this.service != null && this.service.isInit()) {
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"<<< Close redmine rest client...");
                }
                this.service.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }
}

