/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProjectAndVersion;
import org.nuiton.jredmine.plugin.SkipOrRunOnlyOnceAware;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGenerator;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGeneratorConfiguration;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractAnnouncementMojo
extends AbstractRedmineMojoWithProjectAndVersion
implements AnnouncementGeneratorConfiguration,
SkipOrRunOnlyOnceAware {
    @Parameter(property="redmine.templateOutputDirectory", defaultValue="${project.build.directory}/generated-sources/announcement", required=true)
    protected File templateOutputDirectory;
    @Parameter(property="redmine.xmlPath", defaultValue="${basedir}/src/changes/changes.xml", required=true)
    protected File xmlPath;
    @Parameter(property="redmine.templateDirectory", defaultValue="org/nuiton/jredmine/plugin/announcement", required=true)
    protected String templateDirectory = "org/nuiton/jredmine/plugin/announcement";
    @Parameter(property="redmine.templateEncoding", defaultValue="${project.build.sourceEncoding}")
    protected String templateEncoding;
    @Parameter
    protected Map<String, Object> announceParameters;
    @Parameter(property="redmine.attachmentLinkTemplate", defaultValue="%URL%/attachments/download/%FILE%")
    protected String attachmentLinkTemplate = "%URL%/attachments/download/%FILE%";
    @Parameter(property="session.topLevelProject.groupId", readonly=true)
    protected String groupId;
    @Parameter(property="session.topLevelProject.artifactId", readonly=true)
    protected String artifactId;
    @Parameter(property="redmine.projectUrl", defaultValue="${session.topLevelProject.url}", required=true)
    protected String projectUrl;
    @Parameter(property="project.packaging", readonly=true)
    protected String packaging;
    @Parameter(property="redmine.finalName", defaultValue="${session.topLevelProject.build.finalName}", required=true)
    protected String finalName;
    @Parameter(property="basedir", required=true)
    protected String basedir;
    @Parameter
    protected String urlDownload;
    @Parameter(property="redmine.developmentTeam", defaultValue="${session.topLevelProject.name} team", required=true)
    protected String developmentTeam;
    @Parameter(property="redmine.introduction", defaultValue="${session.topLevelProject.description}")
    protected String introduction;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;
    @Parameter(property="redmine.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    @Parameter(property="redmine.artifactsFile")
    protected File artifactsFile;
    @Parameter(property="redmine.deploymentUrl", readonly=true)
    protected String deploymentUrl;
    @Component(hint="jredmine-maven-plugin")
    protected VelocityComponent velocity;
    protected Attachment[] attachments;
    protected Map<File, String> artifactUrls;
    protected Map<Attachment, String> attachmentUrls;
    protected List<?> releases;
    protected AnnouncementGenerator generator;
    protected boolean runOnceDone;

    protected abstract String getAnnouncementTemplate();

    protected AbstractAnnouncementMojo() {
        super(true, true);
    }

    @Override
    public String getAttachmentLinkTemplate() {
        return this.attachmentLinkTemplate;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public Map<File, String> getArtifactUrls() {
        return this.artifactUrls;
    }

    @Override
    public Map<Attachment, String> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @Override
    public String getBasedir() {
        return this.basedir;
    }

    @Override
    public String getDeploymentUrl() {
        return this.deploymentUrl;
    }

    @Override
    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    @Override
    public String getFinalName() {
        return this.finalName;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getProjectUrl() {
        return this.projectUrl;
    }

    @Override
    public String getUrlDownload() {
        return this.urlDownload;
    }

    @Override
    public Map<String, Object> getAnnounceParameters() {
        return this.announceParameters;
    }

    @Override
    public boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    public boolean isRunOnlyOnRoot() {
        return this.runOnlyOnRoot;
    }

    @Override
    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    @Override
    public boolean checkRunOnceDone() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("##").append(this.projectId);
        buffer.append("##").append(this.versionId);
        buffer.append("##").append(this.releaseVersion);
        buffer.append("##").append(this.getAnnouncementTemplate());
        String key = buffer.toString();
        return !this.needInvoke(this.runOnce, this.runOnlyOnRoot, key);
    }

    @Override
    protected void init() throws Exception {
        if (this.isGoalSkip()) {
            return;
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = this.isRunOnce() && this.checkRunOnceDone();
        if (this.runOnceDone) {
            return;
        }
        if (!this.xmlPath.exists()) {
            throw new MojoExecutionException("can not find redmine-template at " + this.xmlPath);
        }
        if (StringUtils.isEmpty((String)this.templateEncoding)) {
            this.templateEncoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
        }
        this.generator = new AnnouncementGenerator(this);
        if (this.artifactsFile != null) {
            if (!this.artifactsFile.exists()) {
                throw new MojoExecutionException("The artifactsFile [" + this.artifactsFile + "] does not exists");
            }
            File[] files = PluginHelper.getLinesAsFiles((File)this.artifactsFile);
            Object url = this.deploymentUrl.trim();
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
                this.deploymentUrl = url;
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Deploy url = " + (String)url));
            }
            this.artifactUrls = this.generator.getArtifactsUrls((String)url, this.versionId, this.isVerbose(), files);
        }
        super.init();
        Attachment[] attachments = this.service.getAttachments(this.projectId, this.versionId);
        if (attachments.length == 0) {
            this.getLog().info((CharSequence)"No attachments files");
        } else {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("attachmentLinkTemplate " + this.attachmentLinkTemplate));
                this.getLog().info((CharSequence)("server url " + this.url));
            }
            this.attachmentUrls = this.generator.getAttachmentsUrls(attachments);
        }
        if (this.isVerbose() && this.attachmentUrls != null) {
            for (Map.Entry entry : this.attachmentUrls.entrySet()) {
                Attachment key = (Attachment)entry.getKey();
                String value = (String)entry.getValue();
                this.getLog().info((CharSequence)("attachment file " + key.getFilename() + " -->  " + value));
            }
        }
        ChangesXML changesXml = new ChangesXML(this.xmlPath, this.getLog());
        this.releases = changesXml.getReleaseList();
    }

    @Override
    protected void doAction() throws Exception {
        String template = this.getAnnouncementTemplate();
        File out = this.getOutputFile();
        this.getLog().info((CharSequence)("Apply template [" + template + "]"));
        this.getLog().info((CharSequence)(" from : " + this.xmlPath));
        this.getLog().info((CharSequence)(" to   : " + out));
        VelocityEngine engine = this.velocity.getEngine();
        engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
        Context context = this.generator.createVelocityContext(this.releases);
        this.generator.doGenerate(engine, context, out, this.templateDirectory + "/" + template, this.templateEncoding);
        this.getLog().debug((CharSequence)("Created  announcement [" + template + "] in  " + out));
    }

    protected File getOutputFile() {
        return new File(this.templateOutputDirectory, this.getAnnouncementTemplate());
    }
}

