/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: ModelHelper.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.3/jredmine-client/src/main/java/org/nuiton/jredmine/model/ModelHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/**
 * Some usefull methods on redmine's entities, mainly to filter datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class ModelHelper {

    public static <T extends IdAble> T byId(int id, T... datas) {
        for (T data : datas) {
            if (data.getId() == id) {
                return data;
            }
        }
        return null;
    }

    public static User byLogin(String login, User... users) {
        for (User u : users) {
            if (u.getLogin().equals(login)) {
                return u;
            }
        }
        return null;
    }

    public static Version byVersionName(String name, Version... versions) {
        for (Version u : versions) {
            if (u.getName().equals(name)) {
                return u;
            }
        }
        return null;
    }

    public static Issue[] byTrackerId(int trackerId, Issue... issues) {
        List<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getTrackerId() == trackerId) {
                result.add(i);
            }
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static Issue[] byVersionId(int versionId, Issue... issues) {
        List<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getFixedVersionId() == versionId) {
                result.add(i);
            }
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static <T extends IdAble> T[] byIds(Class<T> type, T[] result, Integer... ids) {

        List<Integer> lIds = Arrays.asList(ids);
        List<T> filter = new ArrayList<T>(lIds.size());
        for (T v : result) {
            if (lIds.contains(v.getId())) {
                filter.add(v);
            }
        }
        return filter.toArray((T[]) Array.newInstance(type, filter.size()));
    }

    public static final Comparator<IdAble> ID_ABLE_COMPARATOR = new Comparator<IdAble>() {

        @Override
        public int compare(IdAble o1, IdAble o2) {
            return o1.getId() - o2.getId();
        }
    };
}
