/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model.io.xpp3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.xpp3.Xpp3Helper;
import org.nuiton.io.xpp3.Xpp3Reader;
import org.nuiton.jredmine.model.RedmineModelEnum;

public class RedmineXpp3Helper {
    private static final Log log = LogFactory.getLog(RedmineXpp3Helper.class);

    public <O> O readObject(Class<O> klass, String txt, boolean strict) throws IOException, XmlPullParserException {
        O result = this.readObject(klass, new ByteArrayInputStream(txt.getBytes()), strict);
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, String txt, boolean strict) throws IOException, XmlPullParserException {
        O[] results = this.readObjects(klass, new ByteArrayInputStream(txt.getBytes()), strict);
        return results;
    }

    public <O> O readObject(Class<O> klass, File file, boolean strict) throws IOException, XmlPullParserException {
        O result = this.readObject(klass, new FileInputStream(file), strict);
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, File file, boolean strict) throws IOException, XmlPullParserException {
        O[] results = this.readObjects(klass, new FileInputStream(file), strict);
        return results;
    }

    public <O> O readObject(Class<O> klass, InputStream stream, boolean strict) throws IOException, XmlPullParserException {
        RedmineModelEnum.safeValueOf(klass);
        O result = this.readObject(klass, (Reader)ReaderFactory.newXmlReader((InputStream)stream), strict);
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, InputStream stream, boolean strict) throws IOException, XmlPullParserException {
        RedmineModelEnum.safeValueOf(klass);
        O[] results = this.readObjects(klass, (Reader)ReaderFactory.newXmlReader((InputStream)stream), strict);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] readObjects(Class<O> klass, Reader reader, boolean strict) throws IOException, XmlPullParserException {
        if (klass == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader parameter can not be null");
        }
        Xpp3Reader modelReader = Xpp3Helper.getReader(klass);
        if (modelReader == null) {
            throw new IllegalArgumentException("could not find xpp3Reader for type " + klass);
        }
        Object[] result = null;
        try {
            StringWriter sWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)sWriter);
            String rawInput = sWriter.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("content to read : \n" + rawInput));
            }
            StringReader sReader = new StringReader(rawInput);
            result = modelReader.readArray((Reader)sReader, strict);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O readObject(Class<O> klass, Reader reader, boolean strict) throws IOException, XmlPullParserException {
        if (klass == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader parameter can not be null");
        }
        Xpp3Reader modelReader = Xpp3Helper.getReader(klass);
        if (modelReader == null) {
            throw new IllegalArgumentException("could not find xpp3Reader for type " + klass);
        }
        Object result = null;
        try {
            StringWriter sWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)sWriter);
            String rawInput = sWriter.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("content to read : \n" + rawInput));
            }
            StringReader sReader = new StringReader(rawInput);
            result = modelReader.read((Reader)sReader, strict);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return (O)result;
    }
}

