/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: RedmineTestContract.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2.1/jredmine-client/src/test/java/org/nuiton/jredmine/RedmineTestContract.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine;

/**
 * Contract of methods to tests for both redmine rest client and redmine service.
 * <p/>
 * Created: 1 janv. 2010
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public interface RedmineTestContract {

    String PROJECT_NAME = "one";

    String VERSION_NAME = "1.0.0";

    String ISSUE_ID = "6";

    void getProjects() throws Exception;

    void getIssuePriorities() throws Exception;

    void getIssueStatuses() throws Exception;

    void getProject() throws Exception;

    void getIssueCategories() throws Exception;

    void getTrackers() throws Exception;

    void getNews() throws Exception;

    void getUserProjects() throws Exception;

    void getProjectMembers() throws Exception;

    void getProjectIssues() throws Exception;

    void getVersions() throws Exception;

    void getVersion() throws Exception;

    void getVersionIssues() throws Exception;

    void getOpenedIssues() throws Exception;

    void getClosedIssues() throws Exception;

    void getIssueTimeEntries() throws Exception;

    void getAttachments() throws Exception;

    void addVersion() throws Exception;

    void addAttachment() throws Exception;

    void addNews() throws Exception;

    void updateVersion() throws Exception;

    void nextVersion() throws Exception;

    void addIssueTime() throws Exception;
}
