/*
 * *##% 
 * JRedmine :: Client
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.model;

/**
 * Une enumeration pour caracteriser le scope d'une donnée dans le modèle.
 * <p/>
 * <p/>
 * Pour une donnée qui ne dépend de rien, elle est en scope {@link #none}.
 * <p/>
 * Pour une donnée qui dépend d'un projet, elle est en scope {@link #project}.
 * <p/>
 * Pour une donnée qui dépend d'une version, elle est en scpoe {@link #version}.
 * <p/>
 * Pour une donnée qui dépend d'une issue, elle est en scpoe {@link #issue}.
 * <p/>
 * A savoir qu'une donnée de scope {@link #version} (resp. {@link #issue}),
 * elle est aussi de scope {@link #project} car la version (resp. l'issue)
 * dépend en dépend.
 *
 * @author chemit
 * @since 1.0.0
 */
public enum RedmineModelScope {

    /**
     * none scope, requires nothing
     */
    none,
    /**
     * project scope, requires a project
     */
    project,
    /**
     * version scope, requires a project and a version
     */
    version,
    /**
     * issue scope, requires a project and an issue
     */
    issue;
}
