package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class StatusMessagePanel extends jaxx.runtime.swing.Table implements java.awt.event.ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_CLOCK = "showClock";
    public static final String PROPERTY_SHOW_I18N = "showI18n";
    public static final String PROPERTY_SHOW_MEMORY_STATUS = "showMemoryStatus";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdX7Ad2+SLQJSIgAKYLjpDh2QEIUZWEtmAMBIRbtjzrewL691ldw9fGsRP4CdAT4NER4UoqCloEH8BIQpaxO6dc3dOLiIubGnmvTdvx2/e/YS8FHBpDwWBLXyqvCG2d+7s7t539nBP3cWyJzyumIDok7PA6kLFjetSwZVuy9BrY3qtwYacUUxT7HoLylLtEywHGCsFFyYZPSlrnbhdD7gvDlRjU1mqb37/sl67r95aAAHX7kr6KWv/YyUvOdUCy3MVnNGTXqAaQbSvbQiP9rXfGVNrECTlPTTEz+ElFFtQ4EhoMQWXT/7kUCPkB1xBsfoIOQRfU3B1wqgc6bF2RyHlyzaWEvXxA0Qx4TzkFhTMywEbtfGQif0IpmDBeLSNb3uTMYIRTeAlA28Q1ntmCrNJY9o0tq/foIfqxQGiLsFCwfqJnG1F8ESgIkNMCzmY6KUab8GYvRMWDa4Uw6ccFiiYS8M2WTCJOVtNP/ix5/axOmZ1R4FGYyWWmqmGy4g1LmZopBBjsoDzEzidVDtJahKlXBfywtdlBcvdo+F+qFtRrJcPxdoIht2/S4vfPv740DzIck7PPpcJTZ2izhgXjOs/zTOj56Ig+8ojtTbi9a5OASb6jsM7Xc0w1hm3tTk9L8qTodtbSA60RL74/dPnpadfp8BqQpkw5DaRwW9DSQ2E3gIjbsBvb4SOTo+m9fe88aag4DDhmjTN3nSRQmuOR12941uBXsJqxhJiJ07py5/FzvuN9CJWjoUny8g/gYJHiUdxeNbji8084wqX2HdZcplZt5ozv2XO+T+H+DPbJAUAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.StatusMessagePanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.Box box;
    protected jaxx.runtime.swing.StatusMessagePanelHandler handler;
    protected java.lang.Boolean showClock;
    protected java.lang.Boolean showI18n;
    protected java.lang.Boolean showMemoryStatus;
    protected javax.swing.JLabel statusLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StatusMessagePanel $Table0 = this;
    private jaxx.runtime.swing.MemoryStatusWidget $MemoryStatusWidget0;
    private jaxx.runtime.swing.ClockWidget $ClockWidget0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // To ensure status bar constant height, no matter what font are in use...
    protected final static String EMPTY_STATUS = " ";
    
    
    public void clearStatus() {
        handler.stopStatusFader(this);
        getStatusLabel().setText(EMPTY_STATUS);
    }
    
    public void setStatus(String status) {
        handler.stopStatusFader(this);
        getStatusLabel().setText(status);
        handler.startStatusFader(this);
    }
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        handler.fadeStatus(this);
    }
    
    public <U extends Component> U getWidget(Class<U> clazz) {
        for (Component component : box.getComponents()) {
            if (clazz == component.getClass()) {
                return (U) component;
            }
        }
        return null;
    }
    
    public void addWidget(Component w) {
        box.add(w);
    }
    
    public void addWidget(Component w, int index) {
        box.add(w, index);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusMessagePanel() {
        $initialize();
    }

    public StatusMessagePanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.Box getBox() {
        return box;
    }

    public jaxx.runtime.swing.StatusMessagePanelHandler getHandler() {
        return handler;
    }

    public java.lang.Boolean getShowClock() {
        return showClock;
    }

    public java.lang.Boolean getShowI18n() {
        return showI18n;
    }

    public java.lang.Boolean getShowMemoryStatus() {
        return showMemoryStatus;
    }

    public javax.swing.JLabel getStatusLabel() {
        return statusLabel;
    }

    public java.lang.Boolean isShowClock() {
        return showClock !=null && showClock;
    }

    public java.lang.Boolean isShowI18n() {
        return showI18n !=null && showI18n;
    }

    public java.lang.Boolean isShowMemoryStatus() {
        return showMemoryStatus !=null && showMemoryStatus;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowClock(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showClock;
        this.showClock = newValue;
        firePropertyChange(PROPERTY_SHOW_CLOCK, oldValue, newValue);
    }

    public void setShowI18n(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showI18n;
        this.showI18n = newValue;
        firePropertyChange(PROPERTY_SHOW_I18N, oldValue, newValue);
    }

    public void setShowMemoryStatus(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showMemoryStatus;
        this.showMemoryStatus = newValue;
        firePropertyChange(PROPERTY_SHOW_MEMORY_STATUS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.MemoryStatusWidget get$MemoryStatusWidget0() {
        return $MemoryStatusWidget0;
    }

    protected jaxx.runtime.swing.ClockWidget get$ClockWidget0() {
        return $ClockWidget0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBox() {
        if (!allComponentsCreated) {
            return;
        }
        box.add($MemoryStatusWidget0);
        box.add($ClockWidget0);
    }

    protected void createBox() {
        $objectMap.put("box", box = new javax.swing.Box(0));
        box.setName("box");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.StatusMessagePanelHandler());
    }

    protected void createShowClock() {
        $objectMap.put("showClock", showClock = Boolean.TRUE);
    }

    protected void createShowI18n() {
        $objectMap.put("showI18n", showI18n = Boolean.FALSE);
    }

    protected void createShowMemoryStatus() {
        $objectMap.put("showMemoryStatus", showMemoryStatus = Boolean.TRUE);
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new javax.swing.JLabel());
        statusLabel.setName("statusLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add(statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        add(box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToBox();
        
        // apply 1 property setters
        setBorder(BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createShowMemoryStatus();
        createShowClock();
        createShowI18n();
        createHandler();
        createStatusLabel();
        createBox();
        // inline creation of $MemoryStatusWidget0
        $objectMap.put("$MemoryStatusWidget0", $MemoryStatusWidget0 = new jaxx.runtime.swing.MemoryStatusWidget());
        $MemoryStatusWidget0.setName("$MemoryStatusWidget0");
        // inline creation of $ClockWidget0
        $objectMap.put("$ClockWidget0", $ClockWidget0 = new jaxx.runtime.swing.ClockWidget());
        $ClockWidget0.setName("$ClockWidget0");
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}