/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import jaxx.runtime.swing.model.JaxxFilterableListModel;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.select.FilterableDoubleListConfig;

public class FilterableDoubleListModel<O extends Serializable>
extends AbstractSerializableBean
implements ModelToBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ADD_ENABLED = "addEnabled";
    public static final String PROPERTY_REMOVE_ENABLED = "removeEnabled";
    public static final String PROPERTY_SELECTED_UP_ENABLED = "selectedUpEnabled";
    public static final String PROPERTY_SELECTED_DOWN_ENABLED = "selectedDownEnabled";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SELECTED = "selected";
    protected boolean addEnabled;
    protected boolean removeEnabled;
    protected boolean selectedUpEnabled;
    protected boolean selectedDownEnabled;
    protected Serializable bean;
    protected boolean objectIsAdjusting;
    protected final List<O> universe = new ArrayList<O>();
    protected final JaxxFilterableListModel<O> universeModel = new JaxxFilterableListModel();
    protected final JaxxDefaultListModel<O> selectedModel = new JaxxDefaultListModel();
    private final FilterableDoubleListConfig<O> config;
    int universeSize;
    int selectedSize;

    public FilterableDoubleListModel(FilterableDoubleListConfig<O> config) {
        this.config = config;
        this.selectedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilterableDoubleListModel.this.fireSelectedChange();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilterableDoubleListModel.this.fireSelectedChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilterableDoubleListModel.this.fireSelectedChange();
            }
        });
    }

    private void fireSelectedChange() {
        if (!this.selectedModel.isValueIsAdjusting()) {
            List<O> selected = this.getSelected();
            this.firePropertyChange(PROPERTY_SELECTED, null, selected);
        }
    }

    public JaxxDefaultListModel<O> getSelectedModel() {
        return this.selectedModel;
    }

    public JaxxFilterableListModel<O> getUniverseModel() {
        return this.universeModel;
    }

    public FilterableDoubleListConfig<O> getConfig() {
        return this.config;
    }

    public Class<O> getBeanType() {
        return this.config.getBeanType();
    }

    public boolean isUseMultiSelect() {
        return this.config.isUseMultiSelect();
    }

    public String getProperty() {
        return this.config.getProperty();
    }

    public String getI18nPrefix() {
        return this.config.getI18nPrefix();
    }

    public List<O> getSelected() {
        return this.selectedModel.toList();
    }

    public int getSelectedListSize() {
        return this.selectedModel.size();
    }

    public void setUniverse(Collection<O> universe) {
        this.resetUniverse();
        this.universe.clear();
        if (universe != null) {
            this.universe.addAll(universe);
        }
    }

    public void setSelected(Collection<O> selected) {
        this.setValueIsAdjustingToTrue();
        try {
            this.resetUniverse();
            this.selectedModel.clear();
            if (selected != null) {
                this.addToSelected((O)selected);
            }
        }
        finally {
            this.setValueIsAdjustingToFalse(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSelected(Iterable<O> items) {
        this.setValueIsAdjustingToTrue();
        try {
            for (Serializable item : items) {
                this.addToSelected(item);
            }
        }
        finally {
            this.setValueIsAdjustingToFalse(this.isUseMultiSelect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromSelected(Iterable<O> items) {
        this.setValueIsAdjustingToTrue();
        try {
            for (Serializable item : items) {
                this.removeFromSelected(item);
            }
        }
        finally {
            this.setValueIsAdjustingToFalse(this.isUseMultiSelect());
        }
    }

    public void moveUpSelected(O item) {
        int i = this.selectedModel.indexOf(item);
        this.selectedModel.removeElement(item);
        this.selectedModel.insertElementAt(item, i - 1);
    }

    public void moveDownSelected(O item) {
        int i = this.selectedModel.indexOf(item);
        this.selectedModel.removeElement(item);
        this.selectedModel.insertElementAt(item, i + 1);
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean addEnabled) {
        boolean oldValue = this.isAddEnabled();
        this.addEnabled = addEnabled;
        this.firePropertyChange(PROPERTY_ADD_ENABLED, oldValue, addEnabled);
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        boolean oldValue = this.isRemoveEnabled();
        this.removeEnabled = removeEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_ENABLED, oldValue, removeEnabled);
    }

    public boolean isSelectedUpEnabled() {
        return this.selectedUpEnabled;
    }

    public void setSelectedUpEnabled(boolean selectedUpEnabled) {
        boolean oldValue = this.isSelectedUpEnabled();
        this.selectedUpEnabled = selectedUpEnabled;
        this.firePropertyChange(PROPERTY_SELECTED_UP_ENABLED, oldValue, selectedUpEnabled);
    }

    public boolean isSelectedDownEnabled() {
        return this.selectedDownEnabled;
    }

    public void setSelectedDownEnabled(boolean selectedDownEnabled) {
        boolean oldValue = this.isSelectedDownEnabled();
        this.selectedDownEnabled = selectedDownEnabled;
        this.firePropertyChange(PROPERTY_SELECTED_DOWN_ENABLED, oldValue, selectedDownEnabled);
    }

    public Serializable getBean() {
        return this.bean;
    }

    public void setBean(Serializable bean) {
        Serializable oldValue = this.getBean();
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    private void resetUniverse() {
        this.universeModel.setAllElements(this.universe);
    }

    private void addToSelected(O item) {
        this.selectedModel.addElement(item);
        if (!this.isUseMultiSelect()) {
            this.universeModel.removeElement(item);
        }
    }

    private void removeFromSelected(O item) {
        this.selectedModel.removeElement(item);
        if (!this.isUseMultiSelect()) {
            this.universeModel.addElement(item);
        }
    }

    private void setValueIsAdjustingToTrue() {
        this.universeSize = this.universeModel.size();
        this.selectedSize = this.selectedModel.size();
        this.universeModel.setValueIsAdjusting(true);
        this.selectedModel.setValueIsAdjusting(true);
    }

    private void setValueIsAdjustingToFalse(boolean updateUniverse) {
        int currentSelectedSize;
        this.universeModel.setValueIsAdjusting(false);
        this.selectedModel.setValueIsAdjusting(false);
        if (updateUniverse) {
            this.universeModel.refresh();
        }
        if ((currentSelectedSize = this.selectedModel.size()) <= this.selectedSize) {
            this.selectedModel.refresh(this.selectedSize);
        } else {
            this.selectedModel.refresh();
        }
    }
}

