/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class CoordinatesEditorHandler
implements UIHandler<CoordinatesEditor> {
    public void beforeInit(CoordinatesEditor ui) {
        CoordinatesEditorModel model = new CoordinatesEditorModel();
        model.setFormat(CoordinateFormat.dd);
        model.setQuadrant(0);
        ui.setContextValue(model);
    }

    public void afterInit(CoordinatesEditor ui) {
        ui.getLatitudeDd().init(false);
        ui.getLatitudeDms().init(false);
        ui.getLatitudeDmd().init(false);
        ui.getLongitudeDd().init(true);
        ui.getLongitudeDms().init(true);
        ui.getLongitudeDmd().init(true);
    }

    public void init(CoordinatesEditor ui) {
        CoordinatesEditorModel model = ui.getModel();
        Serializable bean = model.getBean();
        if (bean != null) {
            if (model.getPropertyLatitude() != null) {
                Method latitudeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyLatitude());
                Preconditions.checkNotNull((Object)latitudeMutator, (Object)("could not find mutator for " + model.getPropertyLatitude()));
                model.addPropertyChangeListener("latitude", new ModelPropertyChangeListener(model, latitudeMutator));
            }
            if (model.getPropertyLatitude() != null) {
                Method longitudeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyLongitude());
                Preconditions.checkNotNull((Object)longitudeMutator, (Object)("could not find mutator for " + model.getPropertyLongitude()));
                model.addPropertyChangeListener("longitude", new ModelPropertyChangeListener(model, longitudeMutator));
            }
            if (model.getPropertyQuadrant() != null) {
                Method quadrantMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyQuadrant());
                Preconditions.checkNotNull((Object)quadrantMutator, (Object)("could not find mutator for " + model.getPropertyQuadrant()));
                model.addPropertyChangeListener("quadrant", new ModelPropertyChangeListener(model, quadrantMutator));
            }
        }
    }

    public boolean isQuadrantSelected(Integer value, int requiredValue) {
        return value != null && value == requiredValue;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final CoordinatesEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(CoordinatesEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            try {
                this.mutator.invoke((Object)this.model.getBean(), newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

